/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.variable;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.data.GenericLoaderRegistry;

public class VariableLoaderRegistry<T extends GenericLoaderRegistry.IHaveLoader<T>>
extends GenericLoaderRegistry<T> {
    private final FloatFunction<? extends T> constantConstructor;

    public VariableLoaderRegistry(FloatFunction<? extends T> constantConstructor) {
        super(true);
        this.constantConstructor = constantConstructor;
    }

    public T deserialize(JsonElement element) {
        JsonPrimitive primitive;
        if (element.isJsonPrimitive() && (primitive = element.getAsJsonPrimitive()).isNumber()) {
            return (T)((GenericLoaderRegistry.IHaveLoader)this.constantConstructor.apply(primitive.getAsFloat()));
        }
        return (T)super.deserialize(element);
    }

    public JsonElement serialize(T src) {
        if (src instanceof ConstantFloat) {
            ConstantFloat constant = (ConstantFloat)src;
            return new JsonPrimitive((Number)Float.valueOf(constant.value()));
        }
        return super.serialize(src);
    }

    public T fromNetwork(FriendlyByteBuf buffer) {
        return (T)super.fromNetwork(buffer);
    }

    public static interface FloatFunction<T> {
        public T apply(float var1);
    }

    public static interface ConstantFloat {
        public float value();
    }

    public record ConstantLoader<T extends ConstantFloat & GenericLoaderRegistry.IHaveLoader<?>>(FloatFunction<T> constructor) implements GenericLoaderRegistry.IGenericLoader<T>
    {
        public T deserialize(JsonObject json) {
            return (T)((ConstantFloat)this.constructor.apply(GsonHelper.m_13915_((JsonObject)json, (String)"value")));
        }

        public void serialize(T object, JsonObject json) {
            json.addProperty("value", (Number)Float.valueOf(object.value()));
        }

        public T fromNetwork(FriendlyByteBuf buffer) {
            return (T)((ConstantFloat)this.constructor.apply(buffer.readFloat()));
        }

        public void toNetwork(T object, FriendlyByteBuf buffer) {
            buffer.writeFloat(object.value());
        }
    }
}

