/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.math;

import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import slimeknights.tconstruct.library.json.LevelingValue;
import slimeknights.tconstruct.library.json.math.PostFixFormula;
import slimeknights.tconstruct.library.json.math.SimpleLevelingFormula;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModuleCondition;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ModifierFormula {
    public static final int LEVEL = 0;
    public static final int VALUE = 1;
    public static final int MULTIPLIER = 2;
    public static final int BASE_VALUE = 3;

    public float computeLevel(IToolContext var1, ModifierEntry var2);

    public float apply(float ... var1);

    public JsonObject serialize(JsonObject var1, String[] var2);

    public void toNetwork(FriendlyByteBuf var1);

    public static ModifierFormula deserialize(JsonObject json, String[] variableNames, FallbackFormula fallback) {
        if (json.has("formula")) {
            return PostFixFormula.deserialize(json, variableNames);
        }
        LevelingValue leveling = LevelingValue.deserialize(json);
        return new SimpleLevelingFormula(leveling, fallback);
    }

    public static ModifierFormula fromNetwork(FriendlyByteBuf buffer, int numArguments, FallbackFormula fallback) {
        short size = buffer.readShort();
        if (size == -1) {
            LevelingValue leveling = LevelingValue.fromNetwork(buffer);
            return new SimpleLevelingFormula(leveling, fallback);
        }
        return PostFixFormula.fromNetwork(buffer, size, numArguments);
    }

    @FunctionalInterface
    public static interface FallbackFormula {
        public static final FallbackFormula IDENTITY = arguments -> arguments[0];
        public static final FallbackFormula ADD = arguments -> arguments[0] + arguments[1];
        public static final FallbackFormula PERCENT = arguments -> arguments[1] * (1.0f + arguments[0]);
        public static final FallbackFormula BOOST = arguments -> arguments[1] + arguments[0] * arguments[2];

        public float apply(float[] var1);
    }

    public static abstract class Builder<T extends Builder<T, M>, M>
    extends ModifierModuleCondition.Builder<T>
    implements LevelingValue.Builder<M> {
        protected final String[] variableNames;

        protected abstract M build(ModifierFormula var1);

        @Override
        public M amount(float flat, float leveling) {
            return this.build(new SimpleLevelingFormula(new LevelingValue(flat, leveling), FallbackFormula.IDENTITY));
        }

        public FormulaBuilder<?, M> formula() {
            return new FormulaBuilder(this);
        }

        public Builder(String[] variableNames) {
            this.variableNames = variableNames;
        }

        public static class FormulaBuilder<P extends FormulaBuilder<P, M>, M>
        extends PostFixFormula.Builder<P> {
            private final Builder<?, M> parent;

            protected FormulaBuilder(Builder<?, M> parent) {
                super(parent.variableNames);
                this.parent = parent;
            }

            public M build() {
                return this.parent.build(this.buildFormula());
            }
        }
    }
}

