/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json;

import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;

public record LevelingValue(float flat, float eachLevel) {
    public float compute(float level) {
        return this.flat + this.eachLevel * level;
    }

    public float compute(IToolContext tool, ModifierEntry modifier) {
        if (this.eachLevel != 0.0f) {
            return this.flat + this.eachLevel * modifier.getEffectiveLevel(tool);
        }
        return this.flat;
    }

    public JsonObject serialize(JsonObject json) {
        if (this.flat != 0.0f) {
            json.addProperty("flat", (Number)Float.valueOf(this.flat));
        }
        if (this.eachLevel != 0.0f) {
            json.addProperty("each_level", (Number)Float.valueOf(this.eachLevel));
        }
        return json;
    }

    public static LevelingValue deserialize(JsonObject json) {
        float flat = GsonHelper.m_13820_((JsonObject)json, (String)"flat", (float)0.0f);
        float leveling = GsonHelper.m_13820_((JsonObject)json, (String)"each_level", (float)0.0f);
        return new LevelingValue(flat, leveling);
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.flat);
        buffer.writeFloat(this.eachLevel);
    }

    public static LevelingValue fromNetwork(FriendlyByteBuf buffer) {
        float flat = buffer.readFloat();
        float leveling = buffer.readFloat();
        return new LevelingValue(flat, leveling);
    }

    public static LevelingValue flat(float flat) {
        return new LevelingValue(flat, 0.0f);
    }

    public static LevelingValue eachLevel(float eachLevel) {
        return new LevelingValue(0.0f, eachLevel);
    }

    public static interface Builder<M> {
        public M amount(float var1, float var2);

        default public M flat(float flat) {
            return this.amount(flat, 0.0f);
        }

        default public M eachLevel(float eachLevel) {
            return this.amount(0.0f, eachLevel);
        }
    }
}

