/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.function.IntPredicate;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;

public record IntRange(int min, int max) implements IntPredicate
{
    @Override
    public boolean test(int value) {
        return this.min <= value && value <= this.max;
    }

    private void validateArgument(String key, int value) {
        if (!this.test(value)) {
            throw new IllegalArgumentException(key + " must be between " + this.min + " and " + this.max + " inclusive");
        }
    }

    public IntRange exactly(int value) {
        this.validateArgument("value", value);
        return new IntRange(value, value);
    }

    public IntRange range(int min, int max) {
        this.validateArgument("min", min);
        this.validateArgument("max", max);
        if (min > max) {
            throw new IllegalArgumentException("min must be less than or equal to max");
        }
        return new IntRange(min, max);
    }

    public IntRange min(int min) {
        this.validateArgument("min", min);
        return new IntRange(min, this.max);
    }

    public IntRange max(int max) {
        this.validateArgument("max", max);
        return new IntRange(this.min, max);
    }

    private void validateJsonInt(String key, int value) {
        if (!this.test(value)) {
            throw new JsonSyntaxException(key + " must be between " + this.min + " and " + this.max + " inclusive");
        }
    }

    public IntRange deserialize(JsonElement element) {
        if (element.isJsonObject()) {
            JsonObject json = element.getAsJsonObject();
            int min = GsonHelper.m_13824_((JsonObject)json, (String)"min", (int)this.min);
            int max = GsonHelper.m_13824_((JsonObject)json, (String)"max", (int)this.max);
            this.validateJsonInt("min", min);
            this.validateJsonInt("max", max);
            if (min > max) {
                throw new JsonSyntaxException("min must be smaller than or equal to max");
            }
            return new IntRange(min, max);
        }
        int value = GsonHelper.m_13897_((JsonElement)element, (String)"integer");
        this.validateJsonInt("integer", value);
        return new IntRange(value, value);
    }

    public IntRange getAndDeserialize(JsonObject parent, String key) {
        if (parent.has(key)) {
            return this.deserialize(parent.get(key));
        }
        return this;
    }

    public JsonElement serialize(IntRange range) {
        if (range.min == range.max) {
            this.validateArgument("value", range.min);
            return new JsonPrimitive((Number)range.min);
        }
        JsonObject object = new JsonObject();
        this.validateArgument("min", range.min);
        this.validateArgument("max", range.max);
        if (range.min > this.min) {
            object.addProperty("min", (Number)range.min);
        }
        if (range.max < this.max) {
            object.addProperty("max", (Number)range.max);
        }
        return object;
    }

    public void serializeInto(JsonObject parent, String key, IntRange range) {
        if (!this.equals(range)) {
            parent.add(key, this.serialize(range));
        }
    }

    public static IntRange fromNetwork(FriendlyByteBuf buffer) {
        int min = buffer.m_130242_();
        int max = buffer.m_130242_();
        return new IntRange(min, max);
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.min);
        buffer.m_130130_(this.max);
    }
}

