/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.data.material;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.mantle.data.ResourceLocationSerializer;
import slimeknights.tconstruct.library.client.data.material.AbstractPartSpriteProvider;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;

public class GeneratorPartTextureJsonGenerator
extends GenericDataProvider {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeAdapter(MaterialStatsId.class, (Object)new ResourceLocationSerializer(MaterialStatsId::new, "tconstruct")).setPrettyPrinting().disableHtmlEscaping().create();
    private final String modId;
    private final AbstractPartSpriteProvider spriteProvider;
    private final StatOverride overrides;

    public GeneratorPartTextureJsonGenerator(DataGenerator generator, String modId, AbstractPartSpriteProvider spriteProvider) {
        this(generator, modId, spriteProvider, StatOverride.EMPTY);
    }

    public GeneratorPartTextureJsonGenerator(DataGenerator generator, String modId, AbstractPartSpriteProvider spriteProvider, StatOverride overrides) {
        super(generator, PackType.CLIENT_RESOURCES, "tinkering", GSON);
        this.modId = modId;
        this.spriteProvider = spriteProvider;
        this.overrides = overrides;
    }

    public void m_6865_(HashCache cache) throws IOException {
        JsonObject json = new JsonObject();
        json.addProperty("replace", Boolean.valueOf(false));
        JsonArray parts = new JsonArray();
        for (AbstractPartSpriteProvider.PartSpriteInfo spriteInfo : this.spriteProvider.getSprites()) {
            parts.add(GSON.toJsonTree((Object)spriteInfo));
        }
        json.add("parts", (JsonElement)parts);
        if (!this.overrides.overrides.isEmpty()) {
            json.add("overrides", (JsonElement)this.overrides.serialize());
        }
        this.saveThing(cache, new ResourceLocation(this.modId, "generator_part_textures"), json);
    }

    public String m_6055_() {
        return this.modId + " Command Part Texture JSON Generator";
    }

    public record StatOverride(Map<MaterialStatsId, Set<ResourceLocation>> overrides) {
        public static final StatOverride EMPTY = new StatOverride(Collections.emptyMap());

        public boolean hasOverride(MaterialStatsId statsId, ResourceLocation location) {
            return this.overrides.getOrDefault((Object)statsId, Collections.emptySet()).contains(location);
        }

        public JsonObject serialize() {
            JsonObject json = new JsonObject();
            for (Map.Entry<MaterialStatsId, Set<ResourceLocation>> entry : this.overrides.entrySet()) {
                JsonArray array = new JsonArray();
                for (ResourceLocation value : entry.getValue()) {
                    array.add(value.toString());
                }
                json.add(entry.getKey().toString(), (JsonElement)array);
            }
            return json;
        }

        public static class Builder {
            private final Map<MaterialStatsId, ImmutableSet.Builder<ResourceLocation>> builder = new LinkedHashMap<MaterialStatsId, ImmutableSet.Builder<ResourceLocation>>();

            public Builder add(MaterialStatsId statsId, ResourceLocation texture) {
                this.builder.computeIfAbsent(statsId, id -> ImmutableSet.builder()).add((Object)texture);
                return this;
            }

            public Builder addVariant(MaterialStatsId statsId, MaterialVariantId texture) {
                return this.add(statsId, texture.getLocation('_'));
            }

            public StatOverride build() {
                if (this.builder.isEmpty()) {
                    return EMPTY;
                }
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (Map.Entry<MaterialStatsId, ImmutableSet.Builder<ResourceLocation>> entry : this.builder.entrySet()) {
                    builder.put((Object)entry.getKey(), (Object)entry.getValue().build());
                }
                return new StatOverride((Map<MaterialStatsId, Set<ResourceLocation>>)builder.build());
            }
        }
    }
}

