/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.fluids.fluids;

import java.util.Collection;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

public class PotionFluidAttributes
extends FluidAttributes {
    private static final int EMPTY_COLOR = 0xF800F8;

    public static FluidAttributes.Builder builder(ResourceLocation texturePrefix) {
        String modId = texturePrefix.m_135827_();
        String path = texturePrefix.m_135815_();
        return new Builder(new ResourceLocation(modId, path + "still"), new ResourceLocation(modId, path + "flowing"), PotionFluidAttributes::new);
    }

    protected PotionFluidAttributes(FluidAttributes.Builder builder, Fluid fluid) {
        super(builder, fluid);
    }

    public String getTranslationKey() {
        return "item.minecraft.potion.effect.empty";
    }

    public String getTranslationKey(FluidStack stack) {
        return PotionUtils.m_43577_((CompoundTag)stack.getTag()).m_43492_("item.minecraft.potion.effect.");
    }

    public Component getDisplayName(FluidStack stack) {
        return new TranslatableComponent(this.getTranslationKey(stack));
    }

    public int getColor() {
        return -524040;
    }

    public int getColor(FluidStack stack) {
        return PotionFluidAttributes.getColor(stack.getTag()) | 0xFF000000;
    }

    public ItemStack getBucket(FluidStack fluidStack) {
        ItemStack itemStack = new ItemStack((ItemLike)fluidStack.getFluid().m_6859_());
        itemStack.m_41751_(fluidStack.getTag());
        return itemStack;
    }

    private static int getColor(@Nullable CompoundTag tag) {
        if (tag != null && tag.m_128425_("CustomPotionColor", 99)) {
            return tag.m_128451_("CustomPotionColor");
        }
        if (PotionUtils.m_43577_((CompoundTag)tag) == Potions.f_43598_) {
            return 0xF800F8;
        }
        return PotionUtils.m_43564_((Collection)PotionUtils.m_43566_((CompoundTag)tag));
    }

    private static class Builder
    extends FluidAttributes.Builder {
        protected Builder(ResourceLocation stillTexture, ResourceLocation flowingTexture, BiFunction<FluidAttributes.Builder, Fluid, FluidAttributes> factory) {
            super(stillTexture, flowingTexture, factory);
        }
    }
}

