/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.recipe;

import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.event.AddReloadListenerEvent;
import slimeknights.mantle.data.IEarlySafeManagerReloadListener;

public class RecipeCacheInvalidator
implements IEarlySafeManagerReloadListener {
    private static final RecipeCacheInvalidator INSTANCE = new RecipeCacheInvalidator();
    private static final List<BooleanConsumer> listeners = new ArrayList<BooleanConsumer>();

    public static void addReloadListener(BooleanConsumer runnable) {
        listeners.add(runnable);
    }

    public static DuelSidedListener addDuelSidedListener(Runnable runnable) {
        DuelSidedListener listener = new DuelSidedListener(runnable);
        RecipeCacheInvalidator.addReloadListener(listener);
        return listener;
    }

    public static void reload(boolean client) {
        for (BooleanConsumer runnable : listeners) {
            runnable.accept(client);
        }
    }

    public void onReloadSafe(ResourceManager resourceManager) {
        RecipeCacheInvalidator.reload(false);
    }

    public static void onReloadListenerReload(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)INSTANCE);
    }

    private RecipeCacheInvalidator() {
    }

    public static class DuelSidedListener
    implements BooleanConsumer {
        private final Runnable clearCache;
        private boolean clearQueued = false;

        public void accept(boolean client) {
            if (client) {
                this.clearQueued = true;
            } else {
                this.clearCache();
            }
        }

        public void clearCache() {
            this.clearQueued = false;
            this.clearCache.run();
        }

        public void checkClear() {
            if (this.clearQueued) {
                this.clearCache();
            }
        }

        private DuelSidedListener(Runnable clearCache) {
            this.clearCache = clearCache;
        }
    }
}

