/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.content.gear.mekasuit;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.math.FloatingLong;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;

@ParametersAreNonnullByDefault
public class ModuleGeothermalGeneratorUnit
implements ICustomModule<ModuleGeothermalGeneratorUnit> {
    public void tickServer(IModule<ModuleGeothermalGeneratorUnit> module, Player player) {
        IEnergyContainer energyContainer = module.getEnergyContainer();
        if (energyContainer != null && !energyContainer.getNeeded().isZero()) {
            double highestScaledDegrees = 0.0;
            double legHeight = player.m_6047_() ? 0.6 : 0.7;
            Map fluidsIn = MekanismUtils.getFluidsIn((Player)player, bb -> new AABB(bb.f_82288_, bb.f_82289_, bb.f_82290_, bb.f_82291_, Math.min(bb.f_82289_ + legHeight, bb.f_82292_), bb.f_82293_));
            for (Map.Entry entry : fluidsIn.entrySet()) {
                double scaledDegrees;
                MekanismUtils.FluidInDetails details = (MekanismUtils.FluidInDetails)entry.getValue();
                double height = details.getMaxHeight();
                if (height < 0.25) continue;
                double temperature = 0.0;
                List positions = details.getPositions();
                for (BlockPos position : positions) {
                    temperature += (double)((Fluid)entry.getKey()).getAttributes().getTemperature((BlockAndTintGetter)player.f_19853_, position);
                }
                if (!((temperature /= (double)positions.size()) > 300.0) || !((scaledDegrees = (temperature - 300.0) * height / legHeight) > highestScaledDegrees)) continue;
                highestScaledDegrees = scaledDegrees;
            }
            if (highestScaledDegrees > 0.0 || player.m_6060_()) {
                if (highestScaledDegrees < 200.0 && player.m_6060_()) {
                    highestScaledDegrees = 200.0;
                }
                FloatingLong rate = ((FloatingLong)MekanismGeneratorsConfig.gear.mekaSuitGeothermalChargingRate.get()).multiply((long)module.getInstalledCount()).multiply(highestScaledDegrees);
                energyContainer.insert(rate, Action.EXECUTE, AutomationType.MANUAL);
            }
        }
    }

    @Nullable
    public ICustomModule.ModuleDamageAbsorbInfo getDamageAbsorbInfo(IModule<ModuleGeothermalGeneratorUnit> module, DamageSource damageSource) {
        if (damageSource.m_19384_()) {
            float ratio = MekanismGeneratorsConfig.gear.mekaSuitHeatDamageReductionRatio.get() * ((float)module.getInstalledCount() / (float)module.getData().getMaxStackSize());
            return new ICustomModule.ModuleDamageAbsorbInfo(() -> ratio, () -> FloatingLong.ZERO);
        }
        return null;
    }
}

