/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.loader.forge.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.brigadier.CommandDispatcher;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import me.ichun.mods.cci.api.event.IEvent;
import me.ichun.mods.cci.api.event.IEvents;
import me.ichun.mods.cci.api.socket.ISocket;
import me.ichun.mods.cci.client.command.CCIClientCommand;
import me.ichun.mods.cci.client.core.EventHandlerClient;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.config.EventConfiguration;
import me.ichun.mods.cci.common.config.outcome.Outcome;
import me.ichun.mods.cci.common.event.EventHandler;
import me.ichun.mods.cci.common.logger.LogType;
import me.ichun.mods.cci.common.module.donationalerts.event.DonationAlertsEvents;
import me.ichun.mods.cci.common.module.generic.GenericEvent;
import me.ichun.mods.cci.common.module.mc.config.GameEventConfig;
import me.ichun.mods.cci.common.module.streamelements.event.StreamElementsEvents;
import me.ichun.mods.cci.common.module.streamlabs.event.StreamlabsEvents;
import me.ichun.mods.cci.common.module.twitch.pubsub.ThreadTwitchPubSubSocket;
import me.ichun.mods.cci.common.network.packet.PacketListeners;
import me.ichun.mods.cci.common.thread.SocketHandler;
import me.ichun.mods.cci.loader.forge.EventHandlerServerForge;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import me.ichun.mods.ichunutil.loader.forge.event.client.OverlayChangeEvent;
import me.ichun.shadow.org.json.JSONException;
import me.ichun.shadow.org.json.JSONObject;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class EventHandlerClientForge
extends EventHandlerClient {
    @SubscribeEvent
    public void onOverlayChangeEvent(OverlayChangeEvent event) {
        this.onOverlayChange(event.getCurrentOverlay(), event.getNewOverlay());
    }

    @SubscribeEvent
    public void onRegisterClientCommands(RegisterClientCommandsEvent event) {
        CCIClientCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onClientChatReceived(ClientChatReceivedEvent event) {
        if (event.getType() == ChatType.SYSTEM) {
            for (EventHandler.CommandFeedbackListener listener : EventHandler.commandFeedbackListeners) {
                if (listener.done) continue;
                if (listener.var != null && !listener.var.isEmpty()) {
                    if (listener.keys != null) {
                        String[] stringArray = event.getMessage();
                        if (stringArray instanceof TranslatableComponent) {
                            TranslatableComponent text = (TranslatableComponent)stringArray;
                            for (String key : listener.keys) {
                                if (!key.equals(text.m_131328_())) continue;
                                Minecraft.m_91087_().execute(() -> EventHandler.GLOBAL_VARIABLES.put(listener.var, event.getMessage().getString()));
                                listener.done = true;
                                break;
                            }
                        }
                    } else {
                        Minecraft.m_91087_().execute(() -> EventHandler.GLOBAL_VARIABLES.put(listener.var, event.getMessage().getString()));
                        listener.done = true;
                    }
                }
                if (!listener.done) break;
                event.setCanceled(true);
                break;
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (this.showGuiEditConfig) {
            this.showGuiEditConfig = false;
            Minecraft.m_91087_().m_91152_((Screen)EventHandlerClientForge.getGuiInstance(Minecraft.m_91087_(), null));
        }
        EventHandler.tick();
        if (this.debugMode && this.tabDown && !InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)258) && Screen.m_96638_()) {
            if (this.bufferedReader == null) {
                try {
                    this.bufferedReader = new BufferedReader(new FileReader(new File(ContentCreatorIntegration.cciProfileDir.toFile(), "test.log")));
                    ContentCreatorIntegration.logger.info(LogType.DEBUG, "Loading test.log");
                }
                catch (IOException e) {
                    ContentCreatorIntegration.logger.info(LogType.DEBUG, "Error loading test.log");
                    e.printStackTrace();
                }
            }
            if (this.bufferedReader != null) {
                String[] slPrefixes = new String[]{"Event: ", "Event Replay: ", "Event SL: ", "Event Replay SL: "};
                String[] sePrefixes = new String[]{"Event SE: ", "Event Replay SE: "};
                String[] daPrefixes = new String[]{"Event DA: ", "Event Replay DA: "};
                String[] tpsPrefixes = new String[]{"Event TP: ", "Event Replay TP: "};
                try {
                    String line = null;
                    while ((line = this.bufferedReader.readLine()) != null) {
                        IEvents event1;
                        String eventLine;
                        boolean needBreak = false;
                        for (String s : slPrefixes) {
                            if (!line.startsWith(s)) continue;
                            eventLine = line.substring(s.length());
                            ContentCreatorIntegration.logger.info(LogType.DEBUG, "Event Replay SL: " + eventLine);
                            event1 = StreamlabsEvents.deserialize(new JSONObject(eventLine), 0);
                            if (event1 != null) {
                                for (int i = 0; i < ((StreamlabsEvents)event1).eventCount(); ++i) {
                                    IEvent actualEvent = ((StreamlabsEvents)event1).getEvent(i);
                                    EventHandler.removeEventFromCache(actualEvent.getId());
                                }
                                Minecraft.m_91087_().execute(() -> EventHandlerClientForge.lambda$onClientTick$2((StreamlabsEvents)event1));
                            }
                            needBreak = true;
                            break;
                        }
                        for (String s : sePrefixes) {
                            if (!line.startsWith(s)) continue;
                            eventLine = line.substring(s.length());
                            ContentCreatorIntegration.logger.info(LogType.DEBUG, "Event Replay SE: " + eventLine);
                            event1 = StreamElementsEvents.deserialize(new JSONObject(eventLine), 0);
                            if (event1 != null) {
                                EventHandler.removeEventFromCache(((StreamElementsEvents)event1).getEvent(0).getId());
                                Minecraft.m_91087_().execute(() -> EventHandlerClientForge.lambda$onClientTick$3((StreamElementsEvents)event1));
                            }
                            needBreak = true;
                            break;
                        }
                        for (String s : daPrefixes) {
                            if (!line.startsWith(s)) continue;
                            eventLine = line.substring(s.length());
                            ContentCreatorIntegration.logger.info(LogType.DEBUG, "Event Replay DA: " + eventLine);
                            event1 = DonationAlertsEvents.deserialize(new JSONObject(eventLine), 0);
                            if (event1 != null) {
                                EventHandler.removeEventFromCache(((DonationAlertsEvents)event1).getEvent(0).getId());
                                Minecraft.m_91087_().execute(() -> EventHandlerClientForge.lambda$onClientTick$4((DonationAlertsEvents)event1));
                            }
                            needBreak = true;
                            break;
                        }
                        for (String s : tpsPrefixes) {
                            if (!line.startsWith(s)) continue;
                            eventLine = line.substring(s.length());
                            ContentCreatorIntegration.logger.info(LogType.DEBUG, "Event Replay TP: " + eventLine);
                            for (ISocket socket : SocketHandler.sockets) {
                                if (!(socket instanceof ThreadTwitchPubSubSocket)) continue;
                                GenericEvent event12 = ((ThreadTwitchPubSubSocket)socket).parseMessage(new JSONObject(eventLine));
                                if (event12 == null) break;
                                EventHandler.removeEventFromCache(event12.getEvent(0).getId());
                                Minecraft.m_91087_().execute(() -> EventHandler.triggerOrQueueEvent(event12));
                                break;
                            }
                            needBreak = true;
                            break;
                        }
                        if (!needBreak) continue;
                        break;
                    }
                    if (line == null) {
                        this.bufferedReader.close();
                        this.bufferedReader = null;
                        ContentCreatorIntegration.logger.info(LogType.DEBUG, "End of test.log");
                    }
                }
                catch (IOException | JSONException exception) {
                    // empty catch block
                }
            }
        }
        this.tabDown = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)258);
    }

    @Override
    public void clientConfigChange() {
        if (((EventHandlerServerForge)ContentCreatorIntegration.eventHandlerServer).gameHook != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)((EventHandlerServerForge)ContentCreatorIntegration.eventHandlerServer).gameHook);
            ((EventHandlerServerForge)ContentCreatorIntegration.eventHandlerServer).gameHook = null;
        }
        GameEventConfig.instance = (GameEventConfig)EventConfiguration.GSON.fromJson(EventConfiguration.GSON.toJson((Object)EventHandler.gameEventConfig), GameEventConfig.class);
        if (GameEventConfig.instance.listeners != null) {
            GameEventConfig.instance.listeners = (GameEventConfig.Listener[])Arrays.stream(GameEventConfig.instance.listeners).filter(GameEventConfig.Listener::isValid).toArray(GameEventConfig.Listener[]::new);
            if (GameEventConfig.instance.listeners.length > 0) {
                ((EventHandlerServerForge)ContentCreatorIntegration.eventHandlerServer).gameHook = new EventHandlerServerForge.GameHook();
                MinecraftForge.EVENT_BUS.register((Object)((EventHandlerServerForge)ContentCreatorIntegration.eventHandlerServer).gameHook);
                if (Outcome.canDoServerOutcomes()) {
                    this.sendServerListeners();
                }
            }
        }
    }

    @Override
    public void sendServerListeners() {
        if (iChunUtil.d().getServer() == null || !iChunUtil.d().getServer().m_129792_()) {
            ArrayList<GameEventConfig.Listener> listeners = new ArrayList<GameEventConfig.Listener>();
            for (GameEventConfig.Listener listener : GameEventConfig.instance.listeners) {
                if (listener.isServerEvent == null || !listener.isServerEvent.booleanValue()) continue;
                listeners.add(listener);
            }
            if (!listeners.isEmpty()) {
                ContentCreatorIntegration.channel.sendToServer((AbstractPacket)new PacketListeners(listeners.toArray(new GameEventConfig.Listener[0])));
            }
        }
    }

    private static /* synthetic */ void lambda$onClientTick$4(DonationAlertsEvents event1) {
        EventHandler.triggerOrQueueEvent(event1);
    }

    private static /* synthetic */ void lambda$onClientTick$3(StreamElementsEvents event1) {
        EventHandler.triggerOrQueueEvent(event1);
    }

    private static /* synthetic */ void lambda$onClientTick$2(StreamlabsEvents event1) {
        EventHandler.triggerOrQueueEvent(event1);
    }
}

