/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.loader.forge;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.core.EventHandlerServer;
import me.ichun.mods.cci.common.event.EventHandler;
import me.ichun.mods.cci.common.module.mc.config.GameEventConfig;
import me.ichun.mods.cci.common.network.packet.PacketListenerEvent;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventHandlerServerForge
extends EventHandlerServer {
    public GameHook gameHook;

    @Override
    public void playerDropItem(Player player, ItemStack is, boolean includeThrowerName) {
        ForgeHooks.onPlayerTossEvent((Player)player, (ItemStack)is, (boolean)includeThrowerName);
    }

    @Override
    public void addClientListeners(UUID playerID, GameEventConfig.Listener[] newListeners) {
        this.clientLogout(playerID);
        if (GameEventConfig.instance == null) {
            GameEventConfig.instance = new GameEventConfig();
            this.gameHook = new GameHook();
            MinecraftForge.EVENT_BUS.register((Object)this.gameHook);
        }
        ArrayList listeners = new ArrayList();
        Collections.addAll(listeners, GameEventConfig.instance.listeners);
        Collections.addAll(listeners, newListeners);
        GameEventConfig.instance.listeners = listeners.toArray(new GameEventConfig.Listener[0]);
    }

    @Override
    public void clientLogout(UUID playerID) {
        if (GameEventConfig.instance != null) {
            ArrayList<GameEventConfig.Listener> listeners = new ArrayList<GameEventConfig.Listener>();
            Collections.addAll(listeners, GameEventConfig.instance.listeners);
            if (listeners.removeIf(l -> playerID.equals(l.origin))) {
                GameEventConfig.instance.listeners = listeners.toArray(new GameEventConfig.Listener[0]);
                if (GameEventConfig.instance.listeners.length == 0) {
                    MinecraftForge.EVENT_BUS.unregister((Object)this.gameHook);
                    this.gameHook = null;
                    GameEventConfig.instance = null;
                }
            }
        }
    }

    public static boolean applies(GameEventConfig.Listener listener, @Nonnull Event event) {
        if (listener.isFullName != null && listener.isFullName.booleanValue()) {
            return event.getClass().getName().equals(listener.className);
        }
        String eventClassName = event.getClass().getName();
        eventClassName = eventClassName.substring(eventClassName.lastIndexOf(".") + 1);
        return eventClassName.equals(listener.className);
    }

    public static void process(GameEventConfig.Listener listener, @Nonnull Event event) {
        String actualCancel;
        HashMap<String, Object> args = new HashMap<String, Object>(EventHandler.GLOBAL_VARIABLES);
        args.put("cci-type-config", "minecraft");
        String className = event.getClass().getName();
        className = className.substring(className.lastIndexOf(".") + 1);
        args.put("cci-type-event", className);
        if (listener.origin != null) {
            args.put("cci-type-origin", listener.origin.toString());
        }
        if (listener.preAccessorEvent != null) {
            EventHandler.tryEvents(new me.ichun.mods.cci.common.config.Event[]{listener.preAccessorEvent}, args);
            if (args.containsKey("stopEventProcessing")) {
                return;
            }
        }
        Arrays.stream(listener.staticAccessors).filter(accessor -> accessor.classForStaticAccess != null).forEach(accessor -> accessor.process(null, args));
        if (args.containsKey("stopEventProcessing")) {
            return;
        }
        Arrays.stream(listener.accessors).forEach(accessor -> accessor.process(event, args));
        if (args.containsKey("stopEventProcessing")) {
            return;
        }
        listener.argBasedAccessors.forEach((key, accessors) -> {
            if (args.containsKey(key)) {
                Arrays.stream(accessors).forEach(accessor -> accessor.process(args.get(key), args));
            }
        });
        if (args.containsKey("stopEventProcessing")) {
            return;
        }
        if (listener.event != null || listener.origin != null) {
            if (listener.isServerEvent != null && listener.isServerEvent.booleanValue() && iChunUtil.d().getEffectiveSide().isServer()) {
                if (listener.origin != null) {
                    ServerPlayer player = iChunUtil.d().getServer().m_6846_().m_11259_(listener.origin);
                    if (player != null) {
                        ContentCreatorIntegration.channel.sendTo((AbstractPacket)new PacketListenerEvent(listener.identifier, args), player);
                    }
                } else if (iChunUtil.d().getServer().m_129792_()) {
                    listener.triggerEvent(args);
                }
            } else {
                listener.triggerEvent(args);
            }
        }
        if (listener.cancel != null && (actualCancel = me.ichun.mods.cci.common.config.Event.replaceStringWithVariables(listener.cancel, args)).equalsIgnoreCase("true") && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    public static class GameHook {
        public static final String SORRY = "If you're reading this, I know how dirty this is. I'm sorry.";

        @SubscribeEvent
        public void eventHook(Event event) {
            if (GameEventConfig.instance != null) {
                for (GameEventConfig.Listener listener : GameEventConfig.instance.listeners) {
                    if (!EventHandlerServerForge.applies(listener, event)) continue;
                    EventHandlerServerForge.process(listener, event);
                }
            }
        }
    }
}

