/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.thread;

import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import me.ichun.mods.cci.client.gui.cci.WorkspaceConfigs;
import me.ichun.mods.cci.client.gui.cci.window.WindowToolbar;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.config.EventConfiguration;
import me.ichun.mods.cci.common.event.EventHandler;
import me.ichun.mods.cci.common.logger.LogType;
import me.ichun.mods.cci.common.thread.SocketHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public class ThreadGetOnlineConfigs
extends Thread {
    private final List<? extends String> urls;

    public ThreadGetOnlineConfigs(List<? extends String> urls) {
        this.setName("CCI - Socket Initialiser");
        this.setDaemon(true);
        this.urls = urls;
    }

    @Override
    public void run() {
        TreeMap<String, EventConfiguration> configs = new TreeMap<String, EventConfiguration>();
        for (String string : this.urls) {
            try {
                InputStreamReader fileIn = new InputStreamReader(new URL(string).openStream());
                EventConfiguration config = (EventConfiguration)EventConfiguration.GSON.fromJson((Reader)fileIn, EventConfiguration.class);
                if (config != null) {
                    if (config.type == null || config.type.isEmpty()) {
                        ContentCreatorIntegration.logger.error(LogType.CCI, "Config from url has no type, unusable: " + string);
                        continue;
                    }
                    if (config.type.equals("constants") || config.type.equals("minecraft ")) {
                        ContentCreatorIntegration.logger.error(LogType.CCI, "You can't load an EventConfiguration with a \"constants\" or \"minecraft\" type! That's not how it works! URL: " + string);
                        continue;
                    }
                    config.online = true;
                    config.from = string;
                    configs.put(config.type, config);
                    continue;
                }
                ContentCreatorIntegration.logger.error(LogType.CCI, "Error creating config from url: " + string);
            }
            catch (UnknownHostException e) {
                ContentCreatorIntegration.logger.error(LogType.CCI, "UnknownHostException - Error retrieving from url: " + string + " . Is your internet connection working?");
            }
            catch (MalformedURLException e) {
                ContentCreatorIntegration.logger.error(LogType.CCI, "MalformedURLException - Error retrieving from url: " + string + " . Is your url correct?");
            }
            catch (Exception e) {
                ContentCreatorIntegration.logger.error(LogType.CCI, "Error retrieving from url: " + string);
                e.printStackTrace();
            }
        }
        if (!configs.isEmpty()) {
            Minecraft.m_91087_().execute(() -> {
                EventConfiguration.eventConfigurations.putAll(configs);
                for (Map.Entry e : configs.entrySet()) {
                    ((EventConfiguration)e.getValue()).init((String)e.getKey());
                }
                EventHandler.triggerToast((Component)new TranslatableComponent("cci.toast.loadedOnline"), null);
                if (Minecraft.m_91087_().f_91080_ instanceof WorkspaceConfigs) {
                    WorkspaceConfigs current = (WorkspaceConfigs)Minecraft.m_91087_().f_91080_;
                    ((WindowToolbar.ViewToolbar)((WindowToolbar)current.getByWindowType(WindowToolbar.class)).getCurrentView()).reloadGui();
                }
            });
        }
        SocketHandler.initialiseSockets(null, -1);
    }
}

