/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.network.packet;

import java.util.Optional;
import java.util.UUID;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.config.Event;
import me.ichun.mods.cci.common.config.EventConfiguration;
import me.ichun.mods.cci.common.module.mc.config.GameEventConfig;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

public class PacketListeners
extends AbstractPacket {
    public GameEventConfig.Listener[] listeners;

    public PacketListeners() {
    }

    public PacketListeners(GameEventConfig.Listener[] listeners) {
        this.listeners = listeners;
    }

    public void writeTo(FriendlyByteBuf buf) {
        buf.writeInt(this.listeners.length);
        for (GameEventConfig.Listener listener : this.listeners) {
            Event event = listener.event;
            listener.event = null;
            buf.m_130070_(EventConfiguration.SERIALIZER_GSON.toJson((Object)listener));
            buf.m_130070_(listener.identifier);
            listener.event = event;
        }
    }

    public void readFrom(FriendlyByteBuf buf) {
        this.listeners = new GameEventConfig.Listener[buf.readInt()];
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i] = (GameEventConfig.Listener)EventConfiguration.GSON.fromJson(buf.m_130136_(Short.MAX_VALUE), GameEventConfig.Listener.class);
            this.listeners[i].identifier = buf.m_130136_(Short.MAX_VALUE);
        }
    }

    public Optional<Runnable> process(Player player) {
        if (player != null) {
            UUID playerID = player.m_36316_().getId();
            for (GameEventConfig.Listener listener : this.listeners) {
                listener.origin = playerID;
            }
            if (this.listeners.length > 0) {
                return Optional.of(() -> ContentCreatorIntegration.eventHandlerServer.addClientListeners(playerID, this.listeners));
            }
        }
        return Optional.empty();
    }
}

