/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.network.packet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.logger.LogType;
import me.ichun.mods.cci.common.module.mc.config.GameEventConfig;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

public class PacketListenerEvent
extends AbstractPacket {
    public String identifier;
    public HashMap<String, Object> args;

    public PacketListenerEvent() {
    }

    public PacketListenerEvent(String identifier, HashMap<String, Object> map) {
        this.identifier = identifier;
        this.args = map;
    }

    public static void writeArgs(FriendlyByteBuf buf, HashMap<String, Object> args, @Nullable String outcomeJson) {
        for (Map.Entry<String, Object> e : args.entrySet()) {
            buf.m_130070_(e.getKey());
            if (e.getValue() instanceof Double) {
                buf.writeByte(0);
                buf.writeDouble(((Double)e.getValue()).doubleValue());
                continue;
            }
            if (e.getValue() instanceof Integer) {
                buf.writeByte(1);
                buf.writeInt(((Integer)e.getValue()).intValue());
                continue;
            }
            if (e.getValue() instanceof String) {
                buf.writeByte(2);
                buf.m_130070_((String)e.getValue());
                continue;
            }
            if (e.getValue() instanceof Boolean) {
                buf.writeByte(3);
                buf.writeBoolean(((Boolean)e.getValue()).booleanValue());
                continue;
            }
            if (e.getValue() instanceof ArrayList) {
                ArrayList list = (ArrayList)e.getValue();
                buf.writeByte(4);
                buf.writeInt(list.size());
                for (Object o : list) {
                    buf.m_130070_(o != null ? o.toString() : "");
                }
                continue;
            }
            if (e.getValue() instanceof String[]) {
                String[] strings = (String[])e.getValue();
                buf.writeByte(4);
                buf.writeInt(strings.length);
                for (String s : strings) {
                    buf.m_130070_(s);
                }
                continue;
            }
            if (e.getValue() == null) {
                buf.writeByte(5);
                continue;
            }
            if (outcomeJson != null) {
                ContentCreatorIntegration.logger.error(LogType.CCI, "Writing unsupported arg type for outcome: " + outcomeJson + ", " + e.getKey() + ", " + e.getValue());
            }
            buf.writeByte(-1);
            buf.writeByte(0);
        }
        buf.m_130070_("##endPacket");
    }

    public static void readArgs(FriendlyByteBuf buf, HashMap<String, Object> args) {
        String key = buf.m_130136_(Short.MAX_VALUE);
        while (!key.equals("##endPacket")) {
            byte type = buf.readByte();
            if (type >= 0) {
                String[] o = null;
                if (type == 0) {
                    o = buf.readDouble();
                } else if (type == 1) {
                    o = buf.readInt();
                } else if (type == 2) {
                    o = buf.m_130136_(Short.MAX_VALUE);
                } else if (type == 3) {
                    o = buf.readBoolean();
                } else if (type == 4) {
                    int count = buf.readInt();
                    String[] strings = new String[count];
                    for (int i = 0; i < count; ++i) {
                        strings[i] = buf.m_130136_(Short.MAX_VALUE);
                    }
                    o = strings;
                } else if (type == 5) {
                    o = null;
                }
                args.put(key, o);
            } else {
                buf.readByte();
            }
            key = buf.m_130136_(Short.MAX_VALUE);
        }
    }

    public void writeTo(FriendlyByteBuf buf) {
        buf.m_130070_(this.identifier);
        PacketListenerEvent.writeArgs(buf, this.args, null);
    }

    public void readFrom(FriendlyByteBuf buf) {
        this.identifier = buf.m_130136_(Short.MAX_VALUE);
        this.args = new HashMap();
        PacketListenerEvent.readArgs(buf, this.args);
    }

    public Optional<Runnable> process(Player player) {
        for (GameEventConfig.Listener listener : GameEventConfig.instance.listeners) {
            if (!listener.identifier.equals(this.identifier)) continue;
            return Optional.of(() -> listener.triggerEvent(this.args));
        }
        return Optional.empty();
    }
}

