/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.module.streamelements.event;

import java.util.HashMap;
import java.util.Iterator;
import me.ichun.mods.cci.api.event.IEvent;
import me.ichun.mods.cci.api.event.IEvents;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.config.Event;
import me.ichun.mods.cci.common.logger.LogType;
import me.ichun.mods.cci.common.module.streamelements.event.type.EventInfo;
import me.ichun.shadow.org.json.JSONException;
import me.ichun.shadow.org.json.JSONObject;

public class StreamElementsEvents
implements IEvents {
    private String type;
    private EventInfo event;
    private String eventId;
    private String _for;

    private StreamElementsEvents(String type, EventInfo event, String eventId, String _for) {
        this.type = type;
        this.event = event;
        this.eventId = eventId;
        this._for = _for;
    }

    public static StreamElementsEvents deserialize(JSONObject json, int socketId) {
        String type = null;
        EventInfo event = null;
        String eventId = null;
        String _for = null;
        JSONObject eventInfo = null;
        boolean flagged = false;
        HashMap<String, String> extraArgs = new HashMap<String, String>();
        try {
            Iterator ite = json.keys();
            block27: while (ite.hasNext()) {
                String key;
                switch (key = (String)ite.next()) {
                    case "type": {
                        type = json.getString(key);
                        continue block27;
                    }
                    case "event": {
                        eventId = Event.getRandomIdentifier();
                    }
                    case "data": {
                        JSONObject obj = json.optJSONObject(key);
                        if (obj == null) continue block27;
                        eventInfo = obj;
                        continue block27;
                    }
                    case "_id": {
                        eventId = json.getString(key);
                        continue block27;
                    }
                    case "provider": {
                        _for = json.getString(key);
                        continue block27;
                    }
                    case "flagged": {
                        flagged = json.getBoolean(key);
                        continue block27;
                    }
                    case "providerId": 
                    case "channel": 
                    case "createdAt": 
                    case "updatedAt": 
                    case "listener": 
                    case "name": 
                    case "nonce": 
                    case "ts": {
                        extraArgs.put(key, json.get(key).toString());
                        continue block27;
                    }
                }
                ContentCreatorIntegration.logger.error(LogType.SOCKET_EVENT, "Unknown event key \"" + key + "\" for StreamElements event");
            }
        }
        catch (JSONException e) {
            ContentCreatorIntegration.logger.error(LogType.SOCKET_EVENT, "Error parsing Stream Elements event!");
            e.printStackTrace();
        }
        if (eventInfo != null && eventId != null) {
            event = new EventInfo(eventId, eventInfo);
            if (!event.messages.isEmpty()) {
                event.messages.putAll(extraArgs);
                event.messages.put("cci-type-configId", socketId);
                event.messages.put("flagged", flagged);
                if (type == null && event.messages.containsKey("listener") && (type = event.messages.get("listener").toString()).endsWith("-latest")) {
                    type = type.substring(0, type.length() - 7);
                }
                return new StreamElementsEvents(type, event, eventId, _for);
            }
        }
        return null;
    }

    @Override
    public String configurationType() {
        return "streamelements";
    }

    @Override
    public String eventType() {
        return this.type;
    }

    @Override
    public String forType() {
        return this._for;
    }

    @Override
    public int eventCount() {
        return 1;
    }

    @Override
    public IEvent getEvent(int i) {
        return this.event;
    }
}

