/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.config.outcome;

import java.util.HashMap;
import java.util.List;
import me.ichun.mods.cci.client.event.Toast;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.config.Event;
import me.ichun.mods.cci.common.config.outcome.Outcome;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ToastOutcome
extends Outcome {
    public Integer toastType;
    public String title;
    public String subtitle;
    public String titleColor;
    public String subtitleColor;

    public ToastOutcome() {
        this.type = "toast";
    }

    @Override
    public boolean isClientSide(HashMap<String, Object> args) {
        return true;
    }

    @Override
    public boolean trigger(Player player, HashMap<String, Object> args) {
        this.handleClient(player, args);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleClient(Player player, HashMap<String, Object> args) {
        String title = Event.replaceStringWithVariables(this.title, args);
        String subs = null;
        if (this.subtitle != null) {
            subs = Event.replaceStringWithVariables(this.subtitle, args);
        }
        int tclr = -256;
        int sclr = -1;
        if (this.titleColor != null) {
            String titleColor = Event.replaceStringWithVariables(this.titleColor, args);
            try {
                tclr = Integer.parseInt(titleColor);
            }
            catch (NumberFormatException e) {
                try {
                    tclr = Integer.decode(titleColor);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (this.subtitleColor != null) {
            String subtitleColor = Event.replaceStringWithVariables(this.subtitleColor, args);
            try {
                sclr = Integer.parseInt(subtitleColor);
            }
            catch (NumberFormatException e) {
                try {
                    sclr = Integer.decode(subtitleColor);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        TextComponent textComp = new TextComponent(title);
        List list = Minecraft.m_91087_().f_91062_.m_92865_().m_92414_((FormattedText)textComp, 140, Style.f_131099_);
        if (list.size() > 1) {
            textComp = new TextComponent(((FormattedText)list.get(0)).getString() + "...");
        }
        ContentCreatorIntegration.eventHandlerClient.addOrQueueToast(new Toast((Component)textComp, tclr, (Component)(subs == null ? null : new TextComponent(subs)), sclr, this.toastType != null ? this.toastType : 0));
    }

    @Override
    public boolean isValid() {
        return this.title != null;
    }
}

