/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.config.outcome;

import java.util.HashMap;
import java.util.List;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.config.Event;
import me.ichun.mods.cci.common.config.outcome.Outcome;
import me.ichun.mods.cci.common.logger.LogType;
import me.ichun.mods.ichunutil.common.iChunUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SoundOutcome
extends Outcome {
    public Boolean clientSide;
    public String sound;
    public String target;
    public Double volume;
    public Double pitch;
    public String category;

    public SoundOutcome() {
        this.type = "sound";
    }

    @Override
    public boolean isClientSide(HashMap<String, Object> args) {
        return this.clientSide != null && this.clientSide != false;
    }

    @Override
    public boolean trigger(Player player, HashMap<String, Object> args) {
        ResourceLocation rl = new ResourceLocation(Event.replaceStringWithVariables(this.sound, args));
        if (this.isClientSide(args)) {
            this.triggerClientSide(rl);
        } else {
            SoundEvent soundevent = iChunUtil.d().registrySoundEvents(rl);
            if (soundevent == null) {
                return false;
            }
            List<? extends Entity> targets = Event.getTarget(player, this.target != null ? Event.replaceStringWithVariables(this.target, args) : "");
            if (targets.isEmpty()) {
                return false;
            }
            float volume = this.volume != null ? (float)this.volume.doubleValue() : 1.0f;
            float pitch = this.pitch != null ? (float)this.pitch.doubleValue() : 1.0f;
            for (Entity entity : targets) {
                entity.m_20193_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), soundevent, entity.m_5720_(), volume, pitch);
            }
        }
        return true;
    }

    @Override
    public boolean isValid() {
        return this.sound != null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void triggerClientSide(ResourceLocation rl) {
        float volume = this.volume != null ? (float)this.volume.doubleValue() : 1.0f;
        float pitch = this.pitch != null ? (float)this.pitch.doubleValue() : 1.0f;
        SoundEvent sound = iChunUtil.d().registrySoundEvents(rl);
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance(sound != null ? sound.m_11660_() : rl, this.category != null ? SoundOutcome.getCategoryByName(this.category) : SoundSource.MASTER, volume, pitch, false, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true));
        if (sound == null) {
            ContentCreatorIntegration.logger.info(LogType.EVENT, "Could not find sound but attempted to play anyway: " + rl.toString());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static SoundSource getCategoryByName(String name) {
        for (SoundSource value : SoundSource.values()) {
            if (!value.m_12676_().equals(name)) continue;
            return value;
        }
        return SoundSource.MASTER;
    }
}

