/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.config.outcome;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.config.Event;
import me.ichun.mods.cci.common.config.outcome.Outcome;
import me.ichun.mods.cci.common.logger.LogType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FakeCrashOutcome
extends Outcome {
    public String crashType;
    public String crashDuration;

    public FakeCrashOutcome() {
        this.type = "fakeCrash";
    }

    @Override
    public boolean isClientSide(HashMap<String, Object> args) {
        return true;
    }

    @Override
    public boolean trigger(Player player, HashMap<String, Object> args) {
        ContentCreatorIntegration.logger.info(LogType.EVENT, "We are intentionally (fake) crashing the game!");
        int crashType = Event.getAsInt(Event.replaceStringWithVariables(this.crashType, args));
        int crashDuration = 100;
        if (this.crashDuration != null) {
            crashDuration = Event.getAsInt(Event.replaceStringWithVariables(this.crashDuration, args));
        }
        switch (crashType) {
            case 1: {
                try {
                    Thread.sleep((long)(crashDuration / 20) * 1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return true;
            }
            case 2: {
                this.openOOMScreen(crashDuration);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return this.crashType != null && !this.crashType.isEmpty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openOOMScreen(int duration) {
        Minecraft.m_91087_().m_91152_((Screen)new MemoryErrorScreen(Minecraft.m_91087_().f_91080_, duration));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MemoryErrorScreen
    extends Screen {
        public Screen lastScreen;
        public int duration;
        public int currentDuration;
        private MultiLineLabel message = MultiLineLabel.f_94331_;

        public MemoryErrorScreen(Screen lastScreen, int duration) {
            super((Component)new TranslatableComponent("outOfMemory.title"));
            this.lastScreen = lastScreen;
            this.duration = duration;
        }

        protected void m_7856_() {
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 155, this.f_96544_ / 4 + 120 + 12, 150, 20, (Component)new TranslatableComponent("gui.toTitle"), button -> {}));
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 155 + 160, this.f_96544_ / 4 + 120 + 12, 150, 20, (Component)new TranslatableComponent("menu.quit"), button -> {}));
            this.message = MultiLineLabel.m_94341_((Font)this.f_96547_, (FormattedText)new TranslatableComponent("outOfMemory.message"), (int)295);
        }

        public void m_96624_() {
            super.m_96624_();
            ++this.currentDuration;
            if (this.currentDuration > this.duration) {
                this.f_96541_.m_91152_(this.lastScreen);
            }
        }

        public boolean m_6913_() {
            return false;
        }

        public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            this.m_7333_(poseStack);
            MemoryErrorScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 4 - 60 + 20), (int)0xFFFFFF);
            this.message.m_6516_(poseStack, this.f_96543_ / 2 - 145, this.f_96544_ / 4, 9, 0xA0A0A0);
            super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
    }
}

