/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.config.outcome;

import java.util.HashMap;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.config.Event;
import me.ichun.mods.cci.common.config.outcome.Outcome;
import me.ichun.mods.cci.common.event.EventHandler;
import me.ichun.mods.ichunutil.common.iChunUtil;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CommandOutcome
extends Outcome {
    public String command;
    public Boolean executeAsSelf;
    public String handleFeedback;
    public String[] feedbackKeys;
    public Boolean disableChatCommandFallback;

    public CommandOutcome() {
        this.type = "command";
    }

    @Override
    public boolean isClientSide(HashMap<String, Object> args) {
        return iChunUtil.d().getEffectiveSide().isClient() && !Outcome.canDoServerOutcomes() && this.executeAsSelf != null && this.executeAsSelf != false && (this.disableChatCommandFallback == null || this.disableChatCommandFallback == false);
    }

    @Override
    public boolean trigger(Player player, HashMap<String, Object> args) {
        if (player == null) {
            return false;
        }
        String command = Event.replaceStringWithVariables(this.command, args);
        if (command.startsWith("/cci") || command.startsWith("cci")) {
            return false;
        }
        for (String cmd : ContentCreatorIntegration.configServer.disallowedCommands) {
            if (!command.startsWith("/" + cmd) && !command.startsWith(cmd)) continue;
            return false;
        }
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        if (this.isClientSide(args)) {
            this.sendCommandToServer(player, command);
        } else {
            MinecraftServer server = iChunUtil.d().getServer();
            CommandSourceStack source = this.executeAsSelf != null && this.executeAsSelf != false && player != null ? player.m_20203_() : server.m_129893_();
            boolean oriGameRule = false;
            boolean disableFeedback = false;
            if (this.handleFeedback == null) {
                oriGameRule = source.m_81372_().m_46469_().m_46207_(GameRules.f_46144_);
                ((GameRules.BooleanValue)source.m_81372_().m_46469_().m_46170_(GameRules.f_46144_)).m_46246_(false, server);
                disableFeedback = true;
            }
            boolean commandsAllowedForAll = server.m_6846_().f_11209_;
            server.m_6846_().f_11209_ = true;
            if (disableFeedback) {
                source.f_81295_ = true;
            }
            server.m_129892_().m_82117_(source, command);
            server.m_6846_().f_11209_ = commandsAllowedForAll;
            if (this.handleFeedback == null) {
                ((GameRules.BooleanValue)source.m_81372_().m_46469_().m_46170_(GameRules.f_46144_)).m_46246_(oriGameRule, server);
            }
        }
        return true;
    }

    @Override
    public boolean isValid() {
        return this.command != null;
    }

    @Override
    public boolean doTrigger(Player player, HashMap<String, Object> args) {
        boolean flag = super.doTrigger(player, args);
        if (flag && this.requiresFeedbackListener()) {
            EventHandler.addCommandFeedbackListener(Event.replaceStringWithVariables(this.handleFeedback, args), this.feedbackKeys);
        }
        return flag;
    }

    public boolean requiresFeedbackListener() {
        return this.executeAsSelf != null && this.executeAsSelf != false && this.handleFeedback != null && !this.handleFeedback.isEmpty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void sendCommandToServer(Player player, String command) {
        if (player instanceof LocalPlayer) {
            boolean flag = false;
            if (Minecraft.m_91087_().f_91074_ != null) {
                if (command.length() > 256) {
                    Minecraft.m_91087_().f_91074_.m_5661_((Component)new TranslatableComponent("cci.component.CommandOutcome.chat.fallbackWarning"), false);
                }
                for (int i = 0; i < command.length(); ++i) {
                    if (SharedConstants.m_136188_((char)command.charAt(i))) continue;
                    flag = true;
                    Minecraft.m_91087_().f_91074_.m_5661_((Component)new TranslatableComponent("cci.component.CommandOutcome.chat.illegalChar"), false);
                    Minecraft.m_91087_().f_91074_.m_5661_((Component)new TranslatableComponent("cci.component.CommandOutcome.chat.illegalCharString", new Object[]{Character.valueOf(command.charAt(i)), command}), false);
                    break;
                }
            }
            if (!flag) {
                ((LocalPlayer)player).m_108739_(command);
            }
        }
    }
}

