/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.config.condition;

import java.util.HashMap;
import java.util.List;
import me.ichun.mods.cci.common.config.Event;
import me.ichun.mods.cci.common.config.condition.Condition;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TwoHighSpaceCondition
extends Condition {
    public String target;
    public String horiRadius;
    public String vertRadius;
    public String tries;
    public String variableName;
    public String customHeight;
    public String customWidth;
    public String minHoriDistance;
    public Boolean requireSolidBlock;

    public TwoHighSpaceCondition() {
        this.type = "freeSpace";
    }

    @Override
    public boolean meetsCondition(HashMap<String, Object> args) {
        List<? extends Entity> targets = Event.getTarget(null, Event.replaceStringWithVariables(this.target, args));
        if (!targets.isEmpty()) {
            double width;
            double horiRad = Event.getAsDouble(Event.replaceStringWithVariables(this.horiRadius, args));
            double vertRad = Event.getAsDouble(Event.replaceStringWithVariables(this.vertRadius, args));
            int triesParsed = Event.getAsInt(Event.replaceStringWithVariables(this.tries, args));
            double height = this.customHeight == null ? 2.0 : Event.getAsDouble(Event.replaceStringWithVariables(this.customHeight, args));
            double d = width = this.customWidth == null ? 1.0 : Event.getAsDouble(Event.replaceStringWithVariables(this.customWidth, args));
            if (height == 0.0 || width == 0.0) {
                return false;
            }
            Entity target = targets.get(0);
            double minHoriDist = this.minHoriDistance != null ? Event.getAsDouble(Event.replaceStringWithVariables(this.minHoriDistance, args)) : -1.0;
            double minX = target.m_20185_() - horiRad;
            double maxX = target.m_20185_() + horiRad;
            double minZ = target.m_20189_() - horiRad;
            double maxZ = target.m_20189_() + horiRad;
            double halfWidth = width / 2.0;
            AABB box = new AABB(-halfWidth, 0.0, -halfWidth, halfWidth, height, halfWidth);
            for (int i = 0; i < triesParsed; ++i) {
                double dX = minX + (maxX - minX) * RAND.nextDouble();
                double dZ = minZ + (maxZ - minZ) * RAND.nextDouble();
                if (Math.sqrt(target.m_20275_(dX, target.m_20186_(), dZ)) < minHoriDist) continue;
                for (double j = -vertRad; j <= vertRad * 2.0 + 1.0; j += 1.0) {
                    BlockPos blockpos = new BlockPos(Mth.m_14107_((double)dX), Mth.m_14107_((double)(target.m_20186_() - j)), Mth.m_14107_((double)dZ));
                    if (this.requireSolidBlock != null && this.requireSolidBlock.booleanValue() && target.m_20193_().m_8055_(blockpos.m_7495_()).m_60795_()) continue;
                    AABB displacedBox = box.m_82338_(blockpos).m_82386_(0.5, 0.0, 0.5).m_82406_(1.0E-5);
                    boolean hasCollision = false;
                    Iterable blockCollisions = target.m_20193_().m_186434_(null, displacedBox);
                    for (VoxelShape voxelshape : blockCollisions) {
                        if (voxelshape.m_83281_()) continue;
                        hasCollision = true;
                        break;
                    }
                    if (hasCollision) continue;
                    String result = String.format("%.2f", (double)Mth.m_14107_((double)dX) + 0.5) + " " + String.format("%.2f", blockpos.m_123342_()) + " " + String.format("%.2f", (double)Mth.m_14107_((double)dZ) + 0.5);
                    args.put(Event.replaceStringWithVariables(this.variableName, args), result);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return this.target != null && !this.target.isEmpty() && this.horiRadius != null && this.vertRadius != null && this.tries != null && this.variableName != null;
    }
}

