/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.config.condition;

import java.util.HashMap;
import java.util.List;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.config.Event;
import me.ichun.mods.cci.common.config.condition.Condition;
import me.ichun.mods.cci.common.logger.LogType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;

public class TargetCondition
extends Condition {
    public String target;
    public String argument;
    public String variableName;

    public TargetCondition() {
        this.type = "target";
    }

    @Override
    public boolean meetsCondition(HashMap<String, Object> args) {
        List<? extends Entity> targets = Event.getTarget(null, Event.replaceStringWithVariables(this.target, args));
        String targArg = Event.replaceStringWithVariables(this.argument, args);
        if (!targets.isEmpty()) {
            Entity target = targets.get(0);
            Object result = null;
            if (targArg.equalsIgnoreCase("name")) {
                result = target.m_7755_().getString();
            } else if (targArg.equalsIgnoreCase("uuid")) {
                result = target.m_142081_().toString();
            } else if (targArg.equalsIgnoreCase("health")) {
                result = target instanceof LivingEntity ? String.format("%.2f", Float.valueOf(((LivingEntity)target).m_21223_())) : "-1";
            } else if (targArg.equalsIgnoreCase("maxhealth")) {
                result = target instanceof LivingEntity ? String.format("%.2f", Float.valueOf(((LivingEntity)target).m_21233_())) : "-1";
            } else if (targArg.equalsIgnoreCase("armor")) {
                result = target instanceof LivingEntity ? Integer.toString(((LivingEntity)target).m_21230_()) : "-1";
            } else if (targArg.equalsIgnoreCase("location")) {
                result = String.format("%.2f", target.m_20185_()) + " " + String.format("%.2f", target.m_20186_()) + " " + String.format("%.2f", target.m_20189_());
            } else if (targArg.equalsIgnoreCase("locationx")) {
                result = String.format("%.2f", target.m_20185_());
            } else if (targArg.equalsIgnoreCase("locationy")) {
                result = String.format("%.2f", target.m_20186_());
            } else if (targArg.equalsIgnoreCase("locationz")) {
                result = String.format("%.2f", target.m_20189_());
            } else if (targArg.equalsIgnoreCase("rotationyaw")) {
                result = String.format("%.2f", Float.valueOf(target.m_146908_()));
            } else if (targArg.equalsIgnoreCase("rotationpitch")) {
                result = String.format("%.2f", Float.valueOf(target.m_146909_()));
            } else if (targArg.startsWith("lookx")) {
                double d;
                try {
                    d = Double.parseDouble(targArg.substring(5));
                }
                catch (NumberFormatException e) {
                    d = 1.0;
                }
                Vec3 look = target.m_20154_();
                result = String.format("%.2f", look.f_82479_ * d);
            } else if (targArg.startsWith("looky")) {
                double d;
                try {
                    d = Double.parseDouble(targArg.substring(5));
                }
                catch (NumberFormatException e) {
                    d = 1.0;
                }
                Vec3 look = target.m_20154_();
                result = String.format("%.2f", look.f_82480_ * d);
            } else if (targArg.startsWith("lookz")) {
                double d;
                try {
                    d = Double.parseDouble(targArg.substring(5));
                }
                catch (NumberFormatException e) {
                    d = 1.0;
                }
                Vec3 look = target.m_20154_();
                result = String.format("%.2f", look.f_82481_ * d);
            } else if (targArg.startsWith("look")) {
                double d;
                try {
                    d = Double.parseDouble(targArg.substring(4));
                }
                catch (NumberFormatException e) {
                    d = 1.0;
                }
                Vec3 look = target.m_20154_();
                result = String.format("%.2f", look.f_82479_ * d) + " " + String.format("%.2f", look.f_82480_ * d) + " " + String.format("%.2f", look.f_82481_ * d);
            } else if (targArg.startsWith("radiusx")) {
                double d;
                try {
                    d = Double.parseDouble(targArg.substring(7));
                }
                catch (NumberFormatException e) {
                    d = 5.0;
                }
                result = String.format("%.2f", target.m_20185_() + (-d + RAND.nextDouble() * (2.0 * d)));
            } else if (targArg.startsWith("radiusy")) {
                double d;
                try {
                    d = Double.parseDouble(targArg.substring(7));
                }
                catch (NumberFormatException e) {
                    d = 5.0;
                }
                result = String.format("%.2f", target.m_20186_() + (-d + RAND.nextDouble() * (2.0 * d)));
            } else if (targArg.startsWith("radiusz")) {
                double d;
                try {
                    d = Double.parseDouble(targArg.substring(7));
                }
                catch (NumberFormatException e) {
                    d = 5.0;
                }
                result = String.format("%.2f", target.m_20189_() + (-d + RAND.nextDouble() * (2.0 * d)));
            } else if (targArg.startsWith("radiush")) {
                double d;
                try {
                    d = Double.parseDouble(targArg.substring(7));
                }
                catch (NumberFormatException e) {
                    d = 5.0;
                }
                result = String.format("%.2f", target.m_20185_() + (-d + RAND.nextDouble() * (2.0 * d))) + " " + String.format("%.2f", target.m_20186_()) + " " + String.format("%.2f", target.m_20189_() + (-d + RAND.nextDouble() * (2.0 * d)));
            } else if (targArg.startsWith("radius")) {
                double d;
                try {
                    d = Double.parseDouble(targArg.substring(6));
                }
                catch (NumberFormatException e) {
                    d = 5.0;
                }
                result = String.format("%.2f", target.m_20185_() + (-d + RAND.nextDouble() * (2.0 * d))) + " " + String.format("%.2f", target.m_20186_() + (-d + RAND.nextDouble() * (2.0 * d))) + " " + String.format("%.2f", target.m_20189_() + (-d + RAND.nextDouble() * (2.0 * d)));
            } else if (targArg.equalsIgnoreCase("biome")) {
                BlockPos blockpos = target.m_142538_();
                LevelChunk chunk = target.m_20193_().m_46745_(blockpos);
                if (target.m_20193_().m_46805_(blockpos) && blockpos.m_123342_() >= 0 && blockpos.m_123342_() < 256 && !chunk.m_6430_()) {
                    result = (String)target.m_20193_().m_204166_(blockpos).m_203439_().map(resourceKey -> resourceKey.m_135782_().toString(), biome -> biome.toString());
                }
            } else if (targArg.equalsIgnoreCase("dim") || targArg.equalsIgnoreCase("dimension")) {
                result = target.f_19853_.m_46472_().m_135782_().toString();
            } else if (targArg.equalsIgnoreCase("lightblock")) {
                BlockPos blockpos = target.m_142538_();
                LevelChunk chunk = target.m_20193_().m_46745_(blockpos);
                if (target.m_20193_().m_46805_(blockpos) && blockpos.m_123342_() >= 0 && blockpos.m_123342_() < 256 && !chunk.m_6430_()) {
                    result = Integer.toString(target.m_20193_().m_45517_(LightLayer.BLOCK, blockpos));
                }
            } else if (targArg.equalsIgnoreCase("light")) {
                BlockPos blockpos = target.m_142538_();
                LevelChunk chunk = target.m_20193_().m_46745_(blockpos);
                if (target.m_20193_().m_46805_(blockpos) && blockpos.m_123342_() >= 0 && blockpos.m_123342_() < 256 && !chunk.m_6430_()) {
                    result = Integer.toString(target.m_20193_().m_7726_().m_7827_().m_75831_(blockpos, 0));
                }
            } else if (targArg.equalsIgnoreCase("diff") || targArg.equalsIgnoreCase("difficulty")) {
                BlockPos blockpos = target.m_142538_();
                LevelChunk chunk = target.m_20193_().m_46745_(blockpos);
                if (target.m_20193_().m_46805_(blockpos) && blockpos.m_123342_() >= 0 && blockpos.m_123342_() < 256 && !chunk.m_6430_()) {
                    DifficultyInstance difficultyinstance = target.m_20193_().m_6436_(blockpos);
                    result = Integer.toString(difficultyinstance.m_19048_().m_19028_());
                }
            } else if (targArg.equalsIgnoreCase("time")) {
                result = Long.toString(target.m_20193_().m_46468_());
            } else if (targArg.equalsIgnoreCase("day")) {
                result = Long.toString(target.m_20193_().m_46468_() / 24000L);
            }
            if (result != null) {
                args.put(Event.replaceStringWithVariables(this.variableName, args), result);
                return true;
            }
            ContentCreatorIntegration.logger.error(LogType.EVENT, "No such target argument found: " + targArg);
            return false;
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return this.target != null && !this.target.isEmpty() && this.argument != null && !this.argument.isEmpty() && this.variableName != null && !this.variableName.isEmpty();
    }
}

