/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import me.ichun.mods.cci.client.core.EventHandlerClient;
import me.ichun.mods.cci.common.config.Event;
import me.ichun.mods.cci.common.core.EventHandlerServer;
import me.ichun.mods.cci.common.event.EventHandler;
import me.ichun.mods.cci.common.logger.LogType;
import me.ichun.mods.cci.common.logger.Logger;
import me.ichun.mods.ichunutil.common.config.ConfigBase;
import me.ichun.mods.ichunutil.common.config.annotations.CategoryDivider;
import me.ichun.mods.ichunutil.common.config.annotations.Prop;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.common.network.PacketChannel;
import net.minecraft.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public abstract class ContentCreatorIntegration {
    public static final String MOD_ID = "contentcreatorintegration";
    public static final String MOD_NAME = "Content Creator Integration";
    public static final int NETWORK_VERSION = 2;
    public static ContentCreatorIntegration modProxy;
    public static Logger logger;
    @OnlyIn(value=Dist.CLIENT)
    public static ConfigClient configClient;
    public static ConfigServer configServer;
    public static PacketChannel channel;
    public static boolean postInit;
    @OnlyIn(value=Dist.CLIENT)
    public static EventHandlerClient eventHandlerClient;
    public static EventHandlerServer eventHandlerServer;
    private static Path cciWorkingDir;
    public static Path cciProfileDir;
    public static Path cciLibsDir;
    public static final ArrayList<String> LOG_TYPES_LIST;

    public static boolean isGameHooksDisabled() {
        return !iChunUtil.d().env().isForge();
    }

    public void init() {
        Path dir;
        org.slf4j.Logger modLogger = LogUtils.getLogger();
        cciWorkingDir = iChunUtil.d().getConfigDir().resolve(MOD_ID);
        if (!Files.exists(cciWorkingDir, new LinkOption[0])) {
            try {
                Files.createDirectory(cciWorkingDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                modLogger.error("Error creating CCI Working Directory. Terminating.", (Throwable)e);
                return;
            }
        }
        if (!Files.exists(dir = cciWorkingDir.resolve("logs"), new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                modLogger.error("Error creating our logs folder. Terminating.", (Throwable)e);
                return;
            }
        }
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate localDate = LocalDate.now();
        Path logFile = dir.resolve(dtf.format(localDate) + ".log");
        logger = new Logger(modLogger, logFile.toFile());
        try {
            Files.list(dir).forEach(path -> {
                File file = path.toFile();
                if (file.isFile() && file.getName().toLowerCase().endsWith(".log") && !file.getName().toLowerCase().equals(dtf.format(localDate) + ".log") && !new File(dir.toFile(), file.getName() + ".gz").exists()) {
                    byte[] buffer = new byte[1024];
                    try (GZIPOutputStream gzos = new GZIPOutputStream(new FileOutputStream(new File(dir.toFile(), file.getName() + ".gz")));
                         FileInputStream input = new FileInputStream(file);){
                        int read;
                        while ((read = input.read(buffer)) > 0) {
                            gzos.write(buffer, 0, read);
                        }
                        gzos.finish();
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        file.delete();
                    }
                }
            });
        }
        catch (IOException e) {
            logger.warn(LogType.CCI, "Error cleaning up the logs folder.");
            e.printStackTrace();
        }
        cciLibsDir = cciWorkingDir.resolve("libs");
        if (!Files.exists(cciLibsDir, new LinkOption[0])) {
            try {
                Files.createDirectory(cciLibsDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                logger.error(LogType.CCI, "Error creating CCI Libraries Directory");
                e.printStackTrace();
            }
        }
        cciProfileDir = cciWorkingDir.resolve("default");
    }

    public String getRenamedMethod(String s) {
        return s;
    }

    public String getRenamedField(String s) {
        return s;
    }

    public static boolean setProfile(String profile) {
        if ("logs".equalsIgnoreCase(profile)) {
            logger.warn(LogType.CCI, "No setting the profile to the logs folder!");
            return false;
        }
        if ("libs".equalsIgnoreCase(profile)) {
            logger.warn(LogType.CCI, "No setting the profile to the libs folder!");
            return false;
        }
        Path path = cciProfileDir;
        cciProfileDir = profile.isEmpty() || "default".equalsIgnoreCase(profile) ? cciWorkingDir.resolve("default") : cciWorkingDir.resolve(profile);
        if (!Files.exists(cciProfileDir, new LinkOption[0])) {
            try {
                Files.createDirectory(cciProfileDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                logger.warn(LogType.CCI, "Error creating CCI profile");
                e.printStackTrace();
                cciProfileDir = path;
                return false;
            }
        }
        return true;
    }

    static {
        LOG_TYPES_LIST = (ArrayList)Util.m_137469_(new ArrayList(), list -> {
            LogType[] values;
            for (LogType type : values = LogType.values()) {
                list.add(type.getName());
            }
        });
    }

    public static class ConfigServer
    extends ConfigBase {
        @CategoryDivider(comment="Full documentation for this mod can be found at: https://content-creator-integration.readthedocs.io\nThis mod is a product of way too many hours of development and testing and is provided free to bridge the gap between content creators and their supporters. Consider donating to the mod author via the CurseForge page!")
        @Prop(validator="stringsInList", comment="Whitelisted Users. These users will be able to trigger serverside outcomes.")
        public List<String> whitelistedUsers = new ArrayList<String>();
        @Prop(comment="Converts the list of whitelisted users to be the list of blacklisted users.")
        public boolean enableBlacklist = false;
        @Prop(min=0.0, max=4.0, comment="Permission level required to use the server commands for CCI")
        public int commandPermissionLevel = 3;
        @Prop(comment="Disallowed Commands. These commands are prevented from being executed by CommandOutcome. EG: To disable \"/time set day\", add the \"time\" command to the list. Does not cover for aliases (EG: /tp and /teleport)")
        public List<String> disallowedCommands = new ArrayList<String>();
        @Prop(validator="logTypeInList", comment="Types of log types to write to disk. Putting socket_event in is the only way to see the raw event information (from the log file) as it is not printed to console. Everything else will still be print to console.")
        public List<String> logTypes = new ArrayList<String>();

        public ConfigServer() {
            super(new String[0]);
        }

        public void onConfigLoaded() {
            if (!iChunUtil.d().getSide().isServer()) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("Initialising. Log types: ");
            Logger.ENABLED_LOG_TYPES.clear();
            block0: for (String typeS : this.logTypes) {
                for (LogType type : LogType.values()) {
                    if (!type.getName().equals(typeS.toLowerCase())) continue;
                    Logger.ENABLED_LOG_TYPES.add(type);
                    sb.append(typeS);
                    sb.append(", ");
                    continue block0;
                }
            }
            logger.info(LogType.CCI, sb.toString().substring(0, sb.toString().length() - 2));
        }

        public void onPropertyChanged(boolean file, String name, Field field, Object oldObj, Object newObj) {
            this.onConfigLoaded();
        }

        @NotNull
        public String getModId() {
            return ContentCreatorIntegration.MOD_ID;
        }

        @NotNull
        public String getConfigName() {
            return ContentCreatorIntegration.MOD_NAME;
        }

        public boolean addToSubfolder() {
            return true;
        }

        public boolean stringsInList(Object o) {
            return o instanceof String;
        }

        public boolean logTypeInList(Object o) {
            String s;
            return o instanceof String && LOG_TYPES_LIST.contains(s = (String)o);
        }
    }

    public static class ConfigClient
    extends ConfigBase {
        @CategoryDivider(comment="Full documentation for this mod can be found at: https://content-creator-integration.readthedocs.io\nThis mod is a product of way too many hours of development and testing and is provided free to bridge the gap between content creators and their supporters. Consider donating to the mod author via the CurseForge page!")
        @Prop(comment="Keeping this on/true makes CCI trigger the first run wizard settings. Turned off by CCI later.")
        public boolean firstRun = true;
        @Prop(comment="Set this if your streamer name is different from your Minecraft name for the $streamer global variable.")
        public String streamerName = "";
        @Prop(min=0.0, max=20.0, comment="Maximum amount of automatic reconnects before trying giving up.")
        public int maxAutomaticReconnects = 3;
        @Prop(comment="The sockets we use can be unreliable at times. Turn this on to get toasts about their status and other events.")
        public boolean enableInformationToasts = true;
        @Prop(validator="stringsInList", comment="URLs to pull online configs from. These should link to a raw file of the configuration. These configs will override local configs.")
        public List<String> onlineConfigs = new ArrayList<String>();
        @Prop(comment="Enable local statistics collection? This information is for your own personal reference. None of it is be sent externally.")
        public boolean stats = true;
        @Prop(comment="Allow outcomes that require a server to wait until the user connects to a server that allows them to send outcomes? Outcomes are normally discarded otherwise.")
        public boolean allowOutcomesRequiringServerWait = true;
        @Prop(min=0.0, max=200.0, comment="Maximum size of the event cache. Caching prevents retriggers of events and allows you to play back events in the CCI gui, but takes more memory.")
        public int maxEventCache = 20;
        @Prop(validator="logTypeInList", comment="Types of log types to write to disk. Putting socket_event in is the only way to see the raw event information (from the log file) as it is not printed to console. Everything else will still be print to console.")
        public List<String> logTypes = new ArrayList<String>();
        @Prop(comment="Default profile name. Defaults to \"default\". If set, will read from that folder within the main CCI directory instead. Change in-game with the editor.")
        public String defaultProfile = "default";
        @CategoryDivider(name="boxesAndStuff", comment="Config options for the GUI library powering CCI's Config Editor, Boxes & Stuff")
        @Prop(min=-1.0, max=6.0, comment="Adjust the scale of the Event Configuration editor. Setting it to 0 makes it follow Minecraft's GUI scale. Set to -1 to do nothing.")
        public int editorGuiScale = 2;
        @Prop(min=0.0, max=100.0, comment="When you select a config in the editor it automatically expands all items with AT MOST this many items.")
        public int guiListExpand = 2;
        @CategoryDivider(name="socket", showInGui=false, comment="Category for socket tokens. These tokens are more likely than not, sensitive information, so be careful who you show these to.\n\nREMEMBER to add quotes around your token.\n\nIf you change these tokens whilst the game is running, please use \"/cci\" and open the Connections window on the top left to restart the sockets.")
        @Prop(validator="stringsInList", comment="Socket Api Tokens for Streamlabs. One token per line. Most likely requires a Streamlabs widget to be open when running. I would recommend the event list widget. To find your socket API token: Go to Streamlabs -> Dashboard -> Settings (in left sidebar) -> API Settings -> API Tokens -> Your Socket API Token")
        public List<String> streamlabsTokens = new ArrayList<String>();
        @Prop(validator="stringsInList", comment="JWT Tokens for StreamElements. One token per line. To find your JWT token: Go to StreamElements -> Dashboard -> Click on your profile name (top right) -> Show secrets")
        public List<String> streamElementsTokens = new ArrayList<String>();
        @Prop(validator="stringsInList", comment="Tokens for DonationAlerts. One token per line")
        public List<String> donationAlertsTokens = new ArrayList<String>();
        @Prop(validator="stringsInList", comment="Twitch channels' chat to listen to. One channel per line.")
        public List<String> twitchChats = new ArrayList<String>();
        @Prop(validator="stringsInList", comment="If you were given a refresh token when you generated your OAuth Token, you can use this config to store it.")
        public List<String> pubsubRefreshTokens = new ArrayList<String>();
        @Prop(validator="stringsInList", comment="We need an OAuth token with the following scopes: bits:read, chat:read, channel:moderate, channel:read:hype_train, channel:read:polls, channel:read:predictions, channel:read:redemptions, channel:read:subscriptions. You can generate one from https://twitchtokengenerator.com/ or use this URL: https://twitchtokengenerator.com/quick/jIAulxmVAS")
        public List<String> pubsubOauthTokens = new ArrayList<String>();

        public ConfigClient() {
            super(new String[]{"contentcreatorintegration.toml"});
        }

        public void onConfigLoaded() {
            StringBuilder sb = new StringBuilder();
            sb.append("Initialising. Log types: ");
            Logger.ENABLED_LOG_TYPES.clear();
            block0: for (String typeS : this.logTypes) {
                for (LogType type : LogType.values()) {
                    if (!type.getName().equals(typeS.toLowerCase())) continue;
                    Logger.ENABLED_LOG_TYPES.add(type);
                    sb.append(typeS);
                    sb.append(", ");
                    continue block0;
                }
            }
            logger.info(LogType.CCI, sb.toString().substring(0, sb.toString().length() - 2));
            if (!this.streamerName.isEmpty()) {
                EventHandler.GLOBAL_VARIABLES.put("streamer", this.streamerName);
            } else {
                EventHandler.GLOBAL_VARIABLES.put("streamer", Event.getPlayerName());
            }
            EventHandler.GLOBAL_VARIABLES.put("playerName", Event.getPlayerName());
            EventHandler.GLOBAL_VARIABLES.put("mcVersion", Event.getMinecraftVersion());
            ContentCreatorIntegration.setProfile(this.defaultProfile);
            EventHandler.readConstants();
            EventHandler.readLibraries();
            EventHandler.combineConstants();
            EventHandler.readGameEventConfig();
            EventHandler.readNotes();
            EventHandler.readStatistics();
        }

        @NotNull
        public String getModId() {
            return ContentCreatorIntegration.MOD_ID;
        }

        @NotNull
        public String getConfigName() {
            return ContentCreatorIntegration.MOD_NAME;
        }

        public ConfigBase.Type getConfigType() {
            return ConfigBase.Type.CLIENT;
        }

        public boolean addToSubfolder() {
            return true;
        }

        public void onPropertyChanged(boolean file, String name, Field field, Object oldObj, Object newObj) {
            this.onConfigLoaded();
        }

        public boolean stringsInList(Object o) {
            return o instanceof String;
        }

        public boolean logTypeInList(Object o) {
            String s;
            return o instanceof String && LOG_TYPES_LIST.contains(s = (String)o);
        }
    }
}

