/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.client.gui.cci.window.popup;

import me.ichun.mods.cci.api.socket.ISocket;
import me.ichun.mods.cci.client.gui.cci.WorkspaceConfigs;
import me.ichun.mods.cci.common.thread.SocketHandler;
import me.ichun.mods.ichunutil.client.gui.bns.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.Rectangle;
import me.ichun.mods.ichunutil.client.gui.bns.Workspace;
import me.ichun.mods.ichunutil.client.gui.bns.constraint.Constrainable;
import me.ichun.mods.ichunutil.client.gui.bns.constraint.Constraint;
import me.ichun.mods.ichunutil.client.gui.bns.window.Window;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.View;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementButton;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementList;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementScrollBar;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementTextWrapper;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.impl.ViewPopup;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import org.jetbrains.annotations.NotNull;

public class WindowConnections
extends Window<WorkspaceConfigs, ViewConnections> {
    public WindowConnections(WorkspaceConfigs parent) {
        super((Workspace)parent);
        this.setView(new ViewConnections(this));
        this.disableDockingEntirely();
    }

    public static class ViewConnections
    extends View<WindowConnections> {
        public ElementList<?> list;
        public boolean hasInit;
        public int tick;

        public ViewConnections(@NotNull WindowConnections parent) {
            super((Window)parent, "cci.gui.connections.title");
            int padding = 3;
            ElementScrollBar sv = new ElementScrollBar((Fragment)this, ElementScrollBar.Orientation.VERTICAL, 0.6f);
            sv.setConstraint(new Constraint((Constrainable)sv).top((Rectangle)this, Constraint.Property.Type.TOP, padding).bottom((Rectangle)this, Constraint.Property.Type.BOTTOM, 40).right((Rectangle)this, Constraint.Property.Type.RIGHT, padding));
            this.elements.add(sv);
            this.list = new ElementList((Fragment)this).setScrollVertical(sv);
            this.list.setConstraint(new Constraint(this.list).bottom((Rectangle)this, Constraint.Property.Type.BOTTOM, 40).left((Rectangle)this, Constraint.Property.Type.LEFT, padding).right((Rectangle)sv, Constraint.Property.Type.LEFT, 0).top((Rectangle)this, Constraint.Property.Type.TOP, padding));
            this.elements.add(this.list);
            ElementButton button = new ElementButton((Fragment)this, I18n.m_118938_((String)"gui.ok", (Object[])new Object[0]), btn -> this.getWorkspace().removeWindow((Window)parent));
            button.setSize(60, 20);
            button.setConstraint(new Constraint((Constrainable)button).bottom((Rectangle)this, Constraint.Property.Type.BOTTOM, 10).right((Rectangle)this, Constraint.Property.Type.RIGHT, 10));
            this.elements.add(button);
            ElementButton buttonRecon = (ElementButton)new ElementButton((Fragment)this, "cci.gui.connections.reconnect", btn -> {
                if (Screen.m_96638_()) {
                    SocketHandler.killSockets(null, -1);
                    if (!SocketHandler.initialiseSockets(null, -1)) {
                        ViewPopup.popup((Workspace)this.getWorkspace(), (double)0.4, (double)120.0, w -> {}, (String[])new String[]{I18n.m_118938_((String)"cci.command.reconnect.failed", (Object[])new Object[]{"all"})});
                    }
                } else {
                    for (ElementList.Item item : this.list.items) {
                        ISocket socket;
                        if (!item.selected || SocketHandler.initialiseSockets((socket = (ISocket)item.getObject()).getSocketType().toLowerCase(), socket.getSocketId())) continue;
                        ViewPopup.popup((Workspace)this.getWorkspace(), (double)0.4, (double)120.0, w -> {}, (String[])new String[]{I18n.m_118938_((String)"cci.command.reconnect.failed", (Object[])new Object[]{socket.getSocketType() + " - " + socket.getSocketId()})});
                    }
                }
                this.repopulate();
            }).setSize(80, 20);
            buttonRecon.setTooltip(I18n.m_118938_((String)"cci.gui.connections.reconnectAll", (Object[])new Object[0]));
            buttonRecon.setConstraint(new Constraint((Constrainable)buttonRecon).bottom((Rectangle)this, Constraint.Property.Type.BOTTOM, 10).left((Rectangle)this, Constraint.Property.Type.LEFT, 10));
            this.elements.add(buttonRecon);
            ElementButton buttonDiscon = (ElementButton)new ElementButton((Fragment)this, "cci.gui.connections.disconnect", btn -> {
                if (Screen.m_96638_()) {
                    if (!SocketHandler.sockets.isEmpty() && !SocketHandler.killSockets(null, -1)) {
                        ViewPopup.popup((Workspace)this.getWorkspace(), (double)0.4, (double)120.0, w -> {}, (String[])new String[]{I18n.m_118938_((String)"cci.command.disconnect.failed", (Object[])new Object[]{"all"})});
                    }
                } else {
                    for (ElementList.Item item : this.list.items) {
                        ISocket socket;
                        if (!item.selected || SocketHandler.killSockets((socket = (ISocket)item.getObject()).getSocketType().toLowerCase(), socket.getSocketId())) continue;
                        ViewPopup.popup((Workspace)this.getWorkspace(), (double)0.4, (double)120.0, w -> {}, (String[])new String[]{I18n.m_118938_((String)"cci.command.disconnect.failed", (Object[])new Object[]{socket.getSocketType() + " - " + socket.getSocketId()})});
                    }
                }
                this.repopulate();
            }).setSize(80, 20);
            buttonDiscon.setTooltip(I18n.m_118938_((String)"cci.gui.connections.disconnectAll", (Object[])new Object[0]));
            buttonDiscon.setConstraint(new Constraint((Constrainable)buttonDiscon).bottom((Rectangle)this, Constraint.Property.Type.BOTTOM, 10).left((Rectangle)buttonRecon, Constraint.Property.Type.RIGHT, 10));
            this.elements.add(buttonDiscon);
        }

        private void repopulate() {
            this.list.m_7522_(null);
            this.list.items.clear();
            for (ISocket socket : SocketHandler.sockets) {
                ElementList.Item item = this.list.addItem((Object)socket);
                item.setTooltip(socket.getClass().getSimpleName());
                String socketName = socket.getSocketType() + " - " + socket.getSocketId();
                String status = socket.isOpen() ? "connected" : "ERROR";
                ElementTextWrapper wrapper = new ElementTextWrapper((Fragment)item).setText(socketName);
                wrapper.setNoWrap().setConstraint(new Constraint((Constrainable)wrapper).left((Rectangle)item, Constraint.Property.Type.LEFT, item.getBorderSize() + 2).top((Rectangle)item, Constraint.Property.Type.TOP, item.getBorderSize()));
                item.addElement((Element)wrapper);
                wrapper = new ElementTextWrapper((Fragment)item).setText(status);
                wrapper.setNoWrap().setConstraint(new Constraint((Constrainable)wrapper).right((Rectangle)item, Constraint.Property.Type.RIGHT, item.getBorderSize() + 4).top((Rectangle)item, Constraint.Property.Type.TOP, item.getBorderSize()));
                item.addElement((Element)wrapper);
            }
            this.list.init();
        }

        public void init() {
            super.init();
            if (!this.hasInit) {
                this.hasInit = true;
                this.repopulate();
            }
        }

        public void tick() {
            super.tick();
            ++this.tick;
            if (this.tick % 10 == 0) {
                for (ElementList.Item item : this.list.items) {
                    ISocket socket = (ISocket)item.getObject();
                    String status = socket.isOpen() ? "connected" : "ERROR";
                    ElementTextWrapper wrapper = (ElementTextWrapper)item.elements.get(1);
                    wrapper.setText(status);
                    wrapper.init();
                }
            }
        }
    }
}

