/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.client.gui.cci;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import me.ichun.mods.cci.api.socket.SocketProvider;
import me.ichun.mods.cci.client.event.Toast;
import me.ichun.mods.cci.client.gui.cci.IRescaled;
import me.ichun.mods.cci.client.gui.cci.window.WindowContents;
import me.ichun.mods.cci.client.gui.cci.window.WindowNavigation;
import me.ichun.mods.cci.client.gui.cci.window.WindowToolbar;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.config.Constants;
import me.ichun.mods.cci.common.config.Event;
import me.ichun.mods.cci.common.config.EventConfiguration;
import me.ichun.mods.cci.common.config.condition.Condition;
import me.ichun.mods.cci.common.config.outcome.Outcome;
import me.ichun.mods.cci.common.event.EventHandler;
import me.ichun.mods.cci.common.module.mc.config.GameEventConfig;
import me.ichun.mods.cci.common.module.mc.config.reflect.ObjectAccessor;
import me.ichun.mods.cci.common.module.mc.config.reflect.ParamInjector;
import me.ichun.mods.cci.common.thread.SocketHandler;
import me.ichun.mods.ichunutil.client.gui.bns.Rectangle;
import me.ichun.mods.ichunutil.client.gui.bns.Workspace;
import me.ichun.mods.ichunutil.client.gui.bns.constraint.Constraint;
import me.ichun.mods.ichunutil.client.gui.bns.window.Window;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementList;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.impl.ViewConfirmation;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.impl.ViewEditList;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.impl.ViewPopup;
import me.ichun.mods.ichunutil.common.iChunUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class WorkspaceConfigs
extends Workspace
implements IRescaled {
    public int oriScale;
    public TreeMap<String, EventConfiguration> eventConfigurations = EventConfiguration.getCopyOfConfigurations();
    public Constants.ConstantsHolder constants = new Constants.ConstantsHolder((Constants)EventConfiguration.GSON.fromJson(EventConfiguration.GSON.toJson((Object)EventHandler.constants), Constants.class));
    public TreeMap<String, Constants.ConstantsHolder> libraries = new TreeMap();
    public GameEventConfig.ConfigHolder gameEventConfig;
    public WindowToolbar windowToolbar;
    public WindowNavigation windowNav;
    public WindowContents windowContents;
    public String clipboardString;
    public Object clipboard;

    public WorkspaceConfigs() {
        super(null, (Component)new TranslatableComponent("cci.gui.title.configs"));
        for (Map.Entry<String, Constants> entry : EventHandler.libraries.entrySet()) {
            this.libraries.put(entry.getKey(), new Constants.ConstantsHolder((Constants)EventConfiguration.GSON.fromJson(EventConfiguration.GSON.toJson((Object)entry.getValue()), Constants.class)));
        }
        if (!ContentCreatorIntegration.isGameHooksDisabled()) {
            this.gameEventConfig = new GameEventConfig.ConfigHolder((GameEventConfig)EventConfiguration.GSON.fromJson(EventConfiguration.GSON.toJson((Object)EventHandler.gameEventConfig), GameEventConfig.class));
        }
        this.windowToolbar = new WindowToolbar(this);
        this.addToDock(this.windowToolbar, Constraint.Property.Type.TOP);
        this.getDock().disableDock(Constraint.Property.Type.TOP);
    }

    public WorkspaceConfigs setScreenAndScale(Minecraft mc, Screen lastScreen) {
        this.setMinecraftStyle(iChunUtil.configClient.bnsMinecraftStyle);
        this.lastScreen = lastScreen;
        if (lastScreen instanceof IRescaled) {
            this.oriScale = ((IRescaled)lastScreen).getOriScale();
            ((IRescaled)lastScreen).setOriScale(mc.f_91066_.f_92072_);
        } else {
            this.oriScale = mc.f_91066_.f_92072_;
        }
        return this;
    }

    protected void m_7856_() {
        if (ContentCreatorIntegration.configClient.editorGuiScale >= 0) {
            this.f_96541_.f_91066_.f_92072_ = ContentCreatorIntegration.configClient.editorGuiScale;
            this.f_96541_.m_5741_();
        }
        if (this.windowNav == null) {
            this.windowNav = new WindowNavigation(this);
            this.addToDock(this.windowNav, Constraint.Property.Type.LEFT);
            this.windowContents = new WindowContents(this);
            this.addToDock(this.windowContents, Constraint.Property.Type.LEFT);
            this.windowContents.constraint.right((Rectangle)this.getDock(), Constraint.Property.Type.RIGHT, -((Integer)this.windowContents.borderSize.get()).intValue() + 1 + (Integer)this.getDock().borderSize.get());
            this.windowContents.constraint.apply();
        }
        super.m_7856_();
        this.windows.forEach(window -> window.resize(this.f_96541_, this.f_96543_, this.f_96544_));
        boolean hasSocket = false;
        for (SocketProvider socketProvider : SocketHandler.SOCKET_PROVIDERS) {
            if (socketProvider.getConfigTokens().get().size() <= 0) continue;
            hasSocket = true;
            break;
        }
        if (!hasSocket) {
            ViewPopup.popup((Workspace)this, (double)0.5, (double)160.0, w -> {}, (String[])new String[]{I18n.m_118938_((String)"cci.gui.noTokens", (Object[])new Object[0])});
        }
    }

    public void m_96624_() {
        super.m_96624_();
        String s = this.f_96541_.f_91068_.m_90876_();
        if (!s.equals(this.clipboardString)) {
            this.clipboardString = s;
            this.clipboard = s;
            try {
                Condition condition = (Condition)EventConfiguration.GSON.fromJson(s, Condition.class);
                if (condition != null) {
                    this.clipboard = condition;
                } else {
                    Outcome outcome = (Outcome)EventConfiguration.GSON.fromJson(s, Outcome.class);
                    if (outcome != null) {
                        this.clipboard = outcome;
                    }
                }
            }
            catch (Exception ignored) {
                try {
                    Event event = (Event)EventConfiguration.GSON.fromJson(s, Event.class);
                    if (event != null && (event.name != null || event.conditions.length != 0 || event.outcomes.length != 0)) {
                        this.clipboard = event;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public boolean m_7933_(int keyCode, int p_keyPressed_2_, int p_keyPressed_3_) {
        WindowContents contents = (WindowContents)this.getByWindowType(WindowContents.class);
        if (this.m_7222_() == contents && Screen.m_96637_()) {
            if (keyCode == 88) {
                this.copySelectedObject(true);
                return true;
            }
            if (keyCode == 67) {
                this.copySelectedObject(false);
                return true;
            }
            if (keyCode == 86) {
                this.pasteCopiedObject();
                return true;
            }
        }
        if (Screen.m_96637_()) {
            if (keyCode == 83) {
                if (((WindowToolbar.ViewToolbar)this.windowToolbar.getCurrentView()).save()) {
                    ContentCreatorIntegration.eventHandlerClient.addOrQueueToast(new Toast((Component)new TranslatableComponent("cci.gui.toolbar.saveApplied"), -256, null, -1, 0));
                } else {
                    ViewPopup.popup((Workspace)this, (double)0.3, (double)110.0, w -> {}, (String[])new String[]{I18n.m_118938_((String)"cci.gui.toolbar.saveError", (Object[])new Object[0])});
                }
                return true;
            }
            if (keyCode == 82) {
                ((WindowToolbar.ViewToolbar)this.windowToolbar.getCurrentView()).reloadConfigs();
            }
        }
        return super.m_7933_(keyCode, p_keyPressed_2_, p_keyPressed_3_);
    }

    public void copySelectedObject(boolean cut) {
        WindowContents contents = (WindowContents)this.getByWindowType(WindowContents.class);
        for (Object obj : ((WindowContents.ViewContents)contents.getCurrentView()).list.items) {
            Object o1;
            ElementList.Item item1 = (ElementList.Item)obj;
            if (!item1.selected) continue;
            if (item1.getObject() instanceof WindowContents.ViewContents.FieldHolder) {
                WindowContents.ViewContents.FieldHolder fh = (WindowContents.ViewContents.FieldHolder)item1.getObject();
                try {
                    Object o = fh.field.get(fh.object);
                    if (o == null) continue;
                    this.clipboard = EventConfiguration.GSON.fromJson(EventConfiguration.GSON.toJson(o), o.getClass());
                    if (this.clipboard instanceof Double || this.clipboard instanceof Integer || this.clipboard instanceof Boolean) {
                        this.clipboard = this.clipboard.toString();
                    }
                    if (this.clipboard instanceof String) {
                        this.clipboardString = (String)this.clipboard;
                        this.f_96541_.f_91068_.m_90911_((String)this.clipboard);
                    }
                    if (this.clipboard instanceof Condition || this.clipboard instanceof Outcome || this.clipboard instanceof Event) {
                        String json;
                        this.clipboardString = json = EventConfiguration.GSON.toJson(this.clipboard);
                        this.f_96541_.f_91068_.m_90911_(json);
                    }
                    this.setToolbarClipboardMessage(cut);
                    if (cut) {
                        item1.m_6348_((double)(item1.getLeft() + 5), (double)(item1.getTop() + 5), 1);
                    }
                    return;
                }
                catch (IllegalAccessException o) {
                    continue;
                }
            }
            if (!(item1.getObject() instanceof WindowNavigation.ViewNavigation.ItemCollapsible)) continue;
            WindowNavigation.ViewNavigation.ItemCollapsible coll = (WindowNavigation.ViewNavigation.ItemCollapsible)item1.getObject();
            if (coll.heldObject instanceof Condition || coll.heldObject instanceof Outcome || coll.heldObject instanceof Event) {
                String json;
                this.clipboard = EventConfiguration.GSON.fromJson(EventConfiguration.GSON.toJson(coll.heldObject), coll.heldObject.getClass());
                this.clipboardString = json = EventConfiguration.GSON.toJson(this.clipboard);
                this.f_96541_.f_91068_.m_90911_(json);
                this.setToolbarClipboardMessage(cut);
                if (cut) {
                    item1.m_6348_((double)(item1.getLeft() + 5), (double)(item1.getTop() + 5), 1);
                }
                return;
            }
            if (!(coll.parentObject instanceof Map) || !((o1 = ((Map)coll.parentObject).get(coll.heldObject)) instanceof Condition) && !(o1 instanceof Outcome) && !(o1 instanceof Event)) continue;
            this.clipboard = EventConfiguration.GSON.fromJson(EventConfiguration.GSON.toJson(o1), o1.getClass());
            this.setToolbarClipboardMessage(cut);
            if (cut) {
                item1.m_6348_((double)(item1.getLeft() + 5), (double)(item1.getTop() + 5), 1);
            }
            return;
        }
    }

    public void setToolbarClipboardMessage(boolean cut) {
        WindowToolbar.ViewToolbar toolbar = (WindowToolbar.ViewToolbar)this.windowToolbar.getCurrentView();
        toolbar.clipboardText.setText(I18n.m_118938_((String)(cut ? "cci.gui.toolbar.cut" : "cci.gui.toolbar.copy"), (Object[])new Object[0]));
        toolbar.clipboardText.init();
        toolbar.textTimeout = 20;
    }

    public void pasteCopiedObject() {
        WindowContents contents = (WindowContents)this.getByWindowType(WindowContents.class);
        for (Object obj : ((WindowContents.ViewContents)contents.getCurrentView()).list.items) {
            ElementList.Item item1 = (ElementList.Item)obj;
            if (!item1.selected) continue;
            if (item1.getObject() instanceof WindowContents.ViewContents.FieldHolder) {
                WindowContents.ViewContents.FieldHolder fh = (WindowContents.ViewContents.FieldHolder)item1.getObject();
                if (this.clipboard instanceof String) {
                    String s = ((String)this.clipboard).trim();
                    if (fh.field.getType() == Double.class) {
                        try {
                            Double d = Double.parseDouble(s);
                            fh.field.set(fh.object, d);
                            this.refreshContentsWindow();
                        }
                        catch (IllegalAccessException | NumberFormatException d) {}
                    } else if (fh.field.getType() == Integer.class) {
                        try {
                            Integer i = Integer.parseInt(s);
                            fh.field.set(fh.object, i);
                            this.refreshContentsWindow();
                        }
                        catch (IllegalAccessException | NumberFormatException i) {}
                    } else if (fh.field.getType() == Boolean.class) {
                        try {
                            if (s.equalsIgnoreCase("true")) {
                                fh.field.set(fh.object, true);
                                this.refreshContentsWindow();
                            }
                        }
                        catch (IllegalAccessException i) {}
                    } else if (fh.field.getType() == String.class) {
                        try {
                            fh.field.set(fh.object, s);
                            this.refreshContentsWindow();
                        }
                        catch (IllegalAccessException i) {
                            // empty catch block
                        }
                    }
                    return;
                }
                if (fh.field.getType() == this.clipboard.getClass() || fh.field.getType().isInstance(this.clipboard)) {
                    try {
                        fh.field.set(fh.object, EventConfiguration.GSON.fromJson(EventConfiguration.GSON.toJson(this.clipboard), this.clipboard.getClass()));
                        ((WindowNavigation.ViewNavigation)((WindowNavigation)this.getByWindowType(WindowNavigation.class)).getCurrentView()).repopulateList();
                        this.refreshContentsWindow();
                        return;
                    }
                    catch (IllegalAccessException s) {
                        continue;
                    }
                }
                if (!fh.field.getType().isArray() || !fh.field.getType().getComponentType().isInstance(this.clipboard)) continue;
                try {
                    Object[] array = (Object[])fh.field.get(fh.object);
                    ArrayList<Object> arrayObjs = array == null ? new ArrayList<Object>() : new ArrayList<Object>(Arrays.asList(array));
                    arrayObjs.add(EventConfiguration.GSON.fromJson(EventConfiguration.GSON.toJson(this.clipboard), this.clipboard.getClass()));
                    Object[] newObjs = (Object[])Array.newInstance(fh.field.getType().getComponentType(), arrayObjs.size());
                    arrayObjs.toArray(newObjs);
                    fh.field.set(fh.object, newObjs);
                    ((WindowNavigation.ViewNavigation)((WindowNavigation)this.getByWindowType(WindowNavigation.class)).getCurrentView()).repopulateList();
                    this.refreshContentsWindow();
                    return;
                }
                catch (IllegalAccessException arrayObjs) {
                    continue;
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (!(item1.getObject() instanceof WindowNavigation.ViewNavigation.ItemCollapsible)) continue;
            WindowNavigation.ViewNavigation.ItemCollapsible collapsible = (WindowNavigation.ViewNavigation.ItemCollapsible)item1.getObject();
            if (!(collapsible.parentObject instanceof Map)) continue;
            Object val = ((Map)collapsible.parentObject).get(collapsible.heldObject);
            if (val.getClass().isArray() && val.getClass().getComponentType().isInstance(this.clipboard)) {
                try {
                    Object[] array = (Object[])val;
                    ArrayList<Object> arrayObjs = new ArrayList<Object>(Arrays.asList(array));
                    arrayObjs.add(EventConfiguration.GSON.fromJson(EventConfiguration.GSON.toJson(this.clipboard), this.clipboard.getClass()));
                    Object[] newObjs = (Object[])Array.newInstance(val.getClass().getComponentType(), arrayObjs.size());
                    arrayObjs.toArray(newObjs);
                    ((Map)collapsible.parentObject).put(collapsible.heldObject, newObjs);
                    ((WindowNavigation.ViewNavigation)((WindowNavigation)this.getByWindowType(WindowNavigation.class)).getCurrentView()).repopulateList();
                    this.refreshContentsWindow();
                    return;
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (val instanceof Event && this.clipboard instanceof Event || val instanceof Condition && this.clipboard instanceof Condition || val instanceof Outcome && this.clipboard instanceof Outcome) {
                ((Map)collapsible.parentObject).put(collapsible.heldObject, EventConfiguration.GSON.fromJson(EventConfiguration.GSON.toJson(this.clipboard), this.clipboard.getClass()));
                ((WindowNavigation.ViewNavigation)((WindowNavigation)this.getByWindowType(WindowNavigation.class)).getCurrentView()).repopulateList();
                this.refreshContentsWindow();
                return;
            }
            if (!(this.clipboard instanceof String)) continue;
            ((Map)collapsible.parentObject).put(this.clipboard.toString(), ((Map)collapsible.parentObject).get(collapsible.heldObject));
            ((Map)collapsible.parentObject).remove(collapsible.heldObject);
            ((WindowNavigation.ViewNavigation)((WindowNavigation)this.getByWindowType(WindowNavigation.class)).getCurrentView()).repopulateList();
            this.refreshContentsWindow();
            return;
        }
    }

    public void refreshContentsWindow() {
        WindowNavigation.ViewNavigation nav = (WindowNavigation.ViewNavigation)((WindowNavigation)this.getByWindowType(WindowNavigation.class)).getCurrentView();
        for (ElementList.Item item : nav.list.items) {
            if (!item.selected) continue;
            ((WindowContents.ViewContents)((WindowContents)this.getByWindowType(WindowContents.class)).getCurrentView()).list.m_7522_(null);
            ((WindowContents.ViewContents)((WindowContents)this.getByWindowType(WindowContents.class)).getCurrentView()).selected((ElementList.Item<WindowNavigation.ViewNavigation.ItemCollapsible>)item);
            return;
        }
    }

    public void m_7379_() {
        for (Window window : this.windows) {
            if (!window.getClass().getName().contains("popup") && !(window.getCurrentView() instanceof ViewEditList) && !(window.getCurrentView() instanceof ViewConfirmation)) continue;
            this.removeWindow(window);
            WindowContents contents = (WindowContents)this.getByWindowType(WindowContents.class);
            this.m_7522_((GuiEventListener)contents);
            contents.m_7522_((GuiEventListener)contents.getCurrentView());
            for (Element element : ((WindowContents.ViewContents)contents.getCurrentView()).elements) {
                if (!(element instanceof ElementList)) continue;
                ((WindowContents.ViewContents)contents.getCurrentView()).m_7522_((GuiEventListener)element);
                break;
            }
            return;
        }
        if (this.hasConfigChanges()) {
            ViewConfirmation.popup((Workspace)this, (double)0.4, (double)120.0, (String)I18n.m_118938_((String)"cci.gui.text.confirmExit.title", (Object[])new Object[0]), (String)I18n.m_118938_((String)"cci.gui.text.confirmExit", (Object[])new Object[0]), w -> super.m_7379_(), workspace -> {});
            return;
        }
        super.m_7379_();
    }

    public void m_7861_() {
        if (this.lastScreen instanceof IRescaled) {
            ((IRescaled)this.lastScreen).setOriScale(this.oriScale);
            this.oriScale = this.f_96541_.f_91066_.f_92072_;
        }
        super.m_7861_();
        if (this.oriScale != this.f_96541_.f_91066_.f_92072_) {
            this.f_96541_.f_91066_.f_92072_ = this.oriScale;
            this.f_96541_.m_5741_();
        }
    }

    public boolean hasConfigChanges() {
        for (Map.Entry<String, Constants.ConstantsHolder> entry : this.libraries.entrySet()) {
            if (EventHandler.libraries.containsKey(entry.getKey()) && EventConfiguration.SIMPLE_GSON.toJson((Object)EventHandler.libraries.get(entry.getKey())).equals(EventConfiguration.SIMPLE_GSON.toJson((Object)entry.getValue().constants))) continue;
            return true;
        }
        return !EventConfiguration.SIMPLE_GSON.toJson(EventConfiguration.eventConfigurations).equals(EventConfiguration.SIMPLE_GSON.toJson(this.eventConfigurations)) || !EventConfiguration.SIMPLE_GSON.toJson((Object)EventHandler.constants).equals(EventConfiguration.SIMPLE_GSON.toJson((Object)this.constants.constants)) || !ContentCreatorIntegration.isGameHooksDisabled() && !EventConfiguration.SIMPLE_GSON.toJson((Object)EventHandler.gameEventConfig).equals(EventConfiguration.SIMPLE_GSON.toJson((Object)this.gameEventConfig.config)) || EventHandler.libraries.size() != this.libraries.size();
    }

    public static String getName(WindowNavigation.ViewNavigation.ItemCollapsible collapsible, Object o) {
        if (o == null) {
            return ChatFormatting.GRAY + "null";
        }
        if (o instanceof Constants) {
            return "Constants";
        }
        if (o instanceof GameEventConfig) {
            return "Game Event Hooks";
        }
        if (o instanceof Field) {
            Field field = (Field)o;
            if (field.getType().isArray()) {
                try {
                    Object[] array = (Object[])field.get(collapsible.parentObject);
                    return field.getName() + " [" + array.length + "]";
                }
                catch (IllegalAccessException array) {}
            } else if (Map.class.isAssignableFrom(field.getType())) {
                try {
                    Map array = (Map)field.get(collapsible.parentObject);
                    return field.getName() + " [" + array.size() + "]";
                }
                catch (IllegalAccessException array) {}
            } else {
                try {
                    return WorkspaceConfigs.getName(collapsible, field.get(collapsible.parentObject));
                }
                catch (IllegalAccessException array) {
                    // empty catch block
                }
            }
            return field.getName() + " " + field.getType().getSimpleName();
        }
        if (o instanceof Map.Entry) {
            Object s = WorkspaceConfigs.getName(collapsible, ((Map.Entry)o).getKey());
            Object value = ((Map.Entry)o).getValue();
            if (value.getClass().isArray()) {
                Object[] array = (Object[])value;
                s = (String)s + " [" + array.length + "]";
            } else if (value instanceof Condition || value instanceof Outcome || value instanceof Event) {
                s = (String)s + " - " + WorkspaceConfigs.getName(collapsible, value);
            }
            return s;
        }
        if (o instanceof WindowContents.ViewContents.FieldHolder) {
            try {
                WindowContents.ViewContents.FieldHolder fh = (WindowContents.ViewContents.FieldHolder)o;
                String name = fh.field.getName();
                if (name.equals("_for")) {
                    name = "for";
                }
                TextComponent text = new TextComponent(ChatFormatting.GOLD + name);
                Object fhObj = fh.field.get(fh.object);
                String fhName = WorkspaceConfigs.getName(collapsible, fhObj);
                if (fh.field.getType() == String.class) {
                    fhName = fhName.replace("$", ChatFormatting.GREEN + "$" + ChatFormatting.RESET);
                }
                text.m_7220_((Component)new TextComponent(ChatFormatting.RESET + ": " + fhName + ChatFormatting.RESET));
                return text.getString();
            }
            catch (IllegalAccessException fh) {
                return ((WindowContents.ViewContents.FieldHolder)o).field.getName();
            }
        }
        if (o.getClass() == String.class || o.getClass() == Boolean.class || o.getClass() == Double.class || o.getClass() == Integer.class) {
            return o.toString();
        }
        if (o instanceof Event) {
            String name;
            String string = name = ((Event)o).name == null ? Event.class.getSimpleName() : "Event: " + ((Event)o).name;
            if (((Event)o).disabled != null && ((Event)o).disabled.booleanValue()) {
                TextComponent text = new TextComponent(ChatFormatting.GRAY + name);
                return text.getString();
            }
            return name;
        }
        if (o instanceof Condition) {
            String name;
            Condition condition = (Condition)o;
            String string = name = condition.displayName != null && !condition.displayName.isEmpty() ? condition.displayName + " - " + o.getClass().getSimpleName() : o.getClass().getSimpleName();
            if (!condition.isValid()) {
                TextComponent text = new TextComponent(ChatFormatting.RED + name);
                return text.getString();
            }
            return name;
        }
        if (o instanceof Outcome) {
            String name;
            Outcome outcome = (Outcome)o;
            String string = name = outcome.displayName != null && !outcome.displayName.isEmpty() ? outcome.displayName + " - " + o.getClass().getSimpleName() : o.getClass().getSimpleName();
            if (!outcome.isValid()) {
                TextComponent text = new TextComponent(ChatFormatting.RED + name);
                return text.getString();
            }
            if (outcome.disabled != null && outcome.disabled.booleanValue()) {
                TextComponent text = new TextComponent(ChatFormatting.GRAY + name);
                return text.getString();
            }
            return name;
        }
        if (o instanceof EventConfiguration) {
            return o.getClass().getSimpleName();
        }
        if (o instanceof EventConfiguration.Configuration) {
            return ((EventConfiguration.Configuration)o)._for == null ? EventConfiguration.Configuration.class.getSimpleName() : "Configuration: " + ((EventConfiguration.Configuration)o)._for;
        }
        if (o.getClass().isArray()) {
            String s = o.getClass().getComponentType().getSimpleName() + " Array [" + ((Object[])o).length + "]";
            if (((Object[])o).length == 1) {
                s = s + ": " + WorkspaceConfigs.getName(collapsible, ((Object[])o)[0]);
            }
            return s;
        }
        if (o instanceof Map) {
            String s = "Map [" + ((Map)o).size() + "]";
            if (((Map)o).size() == 1) {
                for (Map.Entry o1 : ((Map)o).entrySet()) {
                    s = s + ": " + WorkspaceConfigs.getName(collapsible, o1);
                }
            }
            return s;
        }
        if (o instanceof GameEventConfig.Listener) {
            String name;
            Object object = ((GameEventConfig.Listener)o).name == null ? (((GameEventConfig.Listener)o).className == null ? GameEventConfig.Listener.class.getSimpleName() : "Listener: " + ((GameEventConfig.Listener)o).className) : (name = "Listener: " + ((GameEventConfig.Listener)o).name);
            if (((GameEventConfig.Listener)o).disabled != null && ((GameEventConfig.Listener)o).disabled.booleanValue()) {
                TextComponent text = new TextComponent(ChatFormatting.GRAY + name);
                return text.getString();
            }
            return name;
        }
        if (o instanceof ObjectAccessor) {
            return ((ObjectAccessor)o).name == null ? (((ObjectAccessor)o).function == null ? ObjectAccessor.class.getSimpleName() : "ObjectAccessor: " + ((ObjectAccessor)o).function) : "ObjectAccessor: " + ((ObjectAccessor)o).name;
        }
        if (o instanceof ParamInjector) {
            return ((ParamInjector)o).argToPull == null ? ParamInjector.class.getSimpleName() : "ParamInjector: " + ((ParamInjector)o).argToPull;
        }
        return o.toString() + " " + o.getClass().getSimpleName();
    }

    public static ArrayList<String> getComponentDesc(Class<?> clz) {
        ArrayList<String> descs = new ArrayList<String>();
        descs.add(I18n.m_118938_((String)("cci.component." + clz.getSimpleName() + ".description"), (Object[])new Object[0]));
        if (clz.getName().contains("unconditional")) {
            descs.add(I18n.m_118938_((String)"cci.gui.addCondition.unconditional", (Object[])new Object[0]));
        }
        try {
            clz.getDeclaredMethod("isClientSide", HashMap.class);
            descs.add(I18n.m_118938_((String)"cci.gui.addOutcome.potentiallyClientside", (Object[])new Object[0]));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return descs;
    }

    @Override
    public int getOriScale() {
        return this.oriScale;
    }

    @Override
    public void setOriScale(int scale) {
        this.oriScale = scale;
    }
}

