/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.fluid;

import com.buuz135.industrial.fluid.OreFluidInstance;
import com.buuz135.industrial.fluid.OreTitaniumFluidAttributes;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.fluids.FluidAttributes;

public class OreFluid
extends FlowingFluid {
    private final FluidAttributes.Builder fluidAttributes;
    private OreFluidInstance instance;

    public OreFluid(FluidAttributes.Builder fluidAttributes, OreFluidInstance instance) {
        this.fluidAttributes = fluidAttributes;
        this.instance = instance;
    }

    @Nonnull
    public Fluid m_5615_() {
        return this.instance.getFlowingFluid();
    }

    @Nonnull
    public Fluid m_5613_() {
        return this.instance.getSourceFluid();
    }

    protected boolean m_6760_() {
        return false;
    }

    @ParametersAreNonnullByDefault
    protected void m_7456_(LevelAccessor worldIn, BlockPos pos, BlockState state) {
        BlockEntity tileentity = state.m_155947_() ? worldIn.m_7702_(pos) : null;
        Block.m_49892_((BlockState)state, (LevelAccessor)worldIn, (BlockPos)pos, (BlockEntity)tileentity);
    }

    protected int m_6719_(@Nonnull LevelReader world) {
        return 4;
    }

    protected int m_6713_(@Nonnull LevelReader world) {
        return 1;
    }

    @Nonnull
    public Item m_6859_() {
        return this.instance.getBucketFluid();
    }

    @ParametersAreNonnullByDefault
    protected boolean m_5486_(FluidState p_215665_1_, BlockGetter p_215665_2_, BlockPos p_215665_3_, Fluid p_215665_4_, Direction p_215665_5_) {
        return p_215665_5_ == Direction.DOWN && !p_215665_4_.m_205067_(FluidTags.f_13131_);
    }

    public int m_6718_(@Nonnull LevelReader p_205569_1_) {
        return 5;
    }

    protected float m_6752_() {
        return 1.0f;
    }

    @Nonnull
    protected BlockState m_5804_(@Nonnull FluidState state) {
        return (BlockState)this.instance.getBlockFluid().m_49966_().m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(OreFluid.m_76092_((FluidState)state)));
    }

    public boolean m_7444_(@Nonnull FluidState state) {
        return false;
    }

    public int m_7430_(@Nonnull FluidState p_207192_1_) {
        return 0;
    }

    public boolean m_6212_(Fluid fluidIn) {
        return fluidIn == this.instance.getFlowingFluid() || fluidIn == this.instance.getSourceFluid();
    }

    @Nonnull
    protected FluidAttributes createAttributes() {
        return new OreTitaniumFluidAttributes(this.fluidAttributes, (Fluid)this);
    }

    public static class Source
    extends OreFluid {
        public Source(FluidAttributes.Builder fluidAttributes, OreFluidInstance instance) {
            super(fluidAttributes, instance);
        }

        @Override
        public int m_7430_(@Nonnull FluidState p_207192_1_) {
            return 8;
        }

        @Override
        public boolean m_7444_(@Nonnull FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends OreFluid {
        public Flowing(FluidAttributes.Builder fluidAttributes, OreFluidInstance instance) {
            super(fluidAttributes, instance);
            this.m_76142_((FluidState)((FluidState)this.m_76144_().m_61090_()).m_61124_((Property)f_75948_, (Comparable)Integer.valueOf(7)));
        }

        protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.m_7180_(builder);
            builder.m_61104_(new Property[]{f_75948_});
        }

        @Override
        public int m_7430_(@Nonnull FluidState p_207192_1_) {
            return (Integer)p_207192_1_.m_61143_((Property)f_75948_);
        }

        @Override
        public boolean m_7444_(@Nonnull FluidState state) {
            return false;
        }
    }
}

