/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.duckling.common.entity;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.EnumSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.InteractGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.LookAtTradingPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import tech.thatgravyboat.duckling.common.registry.ModEntities;
import tech.thatgravyboat.duckling.common.registry.ModItems;
import tech.thatgravyboat.duckling.common.registry.ModSounds;

public class QuacklingEntity
extends AbstractVillager
implements IAnimatable {
    private static final VillagerTrades.ItemListing HOLIDAY_CAKE = (entity, random) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 3), new ItemStack((ItemLike)ModItems.HOLIDAY_FRUIT_CAKE.get(), 3), 12, 10, 0.05f);
    public static final Ingredient BREEDING_INGREDIENT = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.HOLIDAY_FRUIT_CAKE.get()});
    private static final EntityDataAccessor<Boolean> DRIPPED = SynchedEntityData.m_135353_(QuacklingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<ItemStack> FISHING_ROD = SynchedEntityData.m_135353_(QuacklingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public QuacklingEntity(EntityType<? extends AbstractVillager> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder createQuacklingAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.25);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DRIPPED, (Object)false);
        this.m_20088_().m_135372_(FISHING_ROD, (Object)ItemStack.f_41583_);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        SpawnGroupData initialize = super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
        this.setDripped(world.m_5822_().nextBoolean());
        return initialize;
    }

    public boolean isDripped() {
        return (Boolean)this.m_20088_().m_135370_(DRIPPED);
    }

    public void setDripped(boolean dripped) {
        this.m_20088_().m_135381_(DRIPPED, (Object)dripped);
    }

    public boolean isFishing() {
        return !((ItemStack)this.m_20088_().m_135370_(FISHING_ROD)).m_41619_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new TradeWithPlayerGoal((AbstractVillager)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(1, (Goal)new LookAtTradingPlayerGoal((AbstractVillager)this));
        this.f_21345_.m_25352_(2, (Goal)new FishingGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, BREEDING_INGREDIENT, false));
        this.f_21345_.m_25352_(4, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new InteractGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return ModSounds.DEEP_QUACK.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return ModSounds.QUACKLING_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return ModSounds.QUACKLING_DEATH.get();
    }

    public SoundEvent m_7596_() {
        return this.m_7515_();
    }

    protected SoundEvent m_6068_(boolean sold) {
        return this.m_7515_();
    }

    public void m_35310_() {
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.m_6673_(source)) {
            if (this.isFishing()) {
                ItemStack stack = ((ItemStack)this.m_20088_().m_135370_(FISHING_ROD)).m_41777_();
                this.m_19983_(stack);
                this.m_20088_().m_135381_(FISHING_ROD, (Object)ItemStack.f_41583_);
            }
            this.f_19853_.m_7605_((Entity)this, (byte)13);
        }
        return super.m_6469_(source, amount);
    }

    protected void m_8058_(MerchantOffer offer) {
        this.f_19853_.m_7605_((Entity)this, (byte)14);
    }

    public void m_7822_(byte status) {
        if (status == 13) {
            this.m_35287_((ParticleOptions)ParticleTypes.f_123792_);
        } else if (status == 14) {
            this.m_35287_((ParticleOptions)ParticleTypes.f_123748_);
        } else {
            super.m_7822_(status);
        }
    }

    protected void m_7604_() {
        this.fillRecipesForLevel(1);
        this.fillRecipesForLevel(2);
        this.fillRecipesForLevel(3);
        this.m_6616_().add((Object)HOLIDAY_CAKE.m_5670_((Entity)this, this.f_19796_));
    }

    private void fillRecipesForLevel(int level) {
        VillagerTrades.ItemListing[] factories;
        Int2ObjectMap int2ObjectMap = (Int2ObjectMap)VillagerTrades.f_35627_.get(VillagerProfession.f_35591_);
        if (int2ObjectMap != null && !int2ObjectMap.isEmpty() && (factories = (VillagerTrades.ItemListing[])int2ObjectMap.get(level)) != null) {
            MerchantOffers tradeOfferList = this.m_6616_();
            this.m_35277_(tradeOfferList, factories, 2);
        }
    }

    public boolean m_7826_() {
        return false;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_(Items.f_42523_) && !this.isFishing()) {
            this.m_20088_().m_135381_(FISHING_ROD, (Object)itemStack);
            player.m_21008_(hand, ItemStack.f_41583_);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (this.isFishing() && itemStack.m_41619_() && player.m_6144_()) {
            ItemStack stack = ((ItemStack)this.m_20088_().m_135370_(FISHING_ROD)).m_41777_();
            this.m_20088_().m_135381_(FISHING_ROD, (Object)ItemStack.f_41583_);
            player.m_21008_(hand, stack);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (itemStack.m_150930_(Items.f_42574_) && this.isDripped()) {
            this.setDripped(false);
            this.m_19998_((ItemLike)Items.f_151018_);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (this.m_21223_() < this.m_21233_() && itemStack.m_150930_(ModItems.HOLIDAY_FRUIT_CAKE.get()) && this.m_6084_()) {
            this.m_5634_(1.0f);
            itemStack.m_41774_(1);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), this.f_19796_.nextGaussian() * 0.02, this.f_19796_.nextGaussian() * 0.02, this.f_19796_.nextGaussian() * 0.02);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (!itemStack.m_150930_((Item)ModItems.QUACKLING_SPAWN_EGG.get()) && this.m_6084_() && !this.m_35306_() && !this.isFishing()) {
            if (hand == InteractionHand.MAIN_HAND) {
                player.m_36220_(Stats.f_12940_);
            }
            if (!this.m_6616_().isEmpty() && !this.f_19853_.f_46443_) {
                this.m_7189_(player);
                this.m_45301_(player, this.m_5446_(), 1);
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setDripped(nbt.m_128471_("Dripped"));
        if (nbt.m_128425_("FishingRod", 10)) {
            this.m_20088_().m_135381_(FISHING_ROD, (Object)ItemStack.m_41712_((CompoundTag)nbt.m_128469_("FishingRod")));
        }
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("Dripped", this.isDripped());
        ItemStack stack = (ItemStack)this.m_20088_().m_135370_(FISHING_ROD);
        if (!stack.m_41619_()) {
            nbt.m_128365_("FishingRod", (Tag)stack.m_41739_(new CompoundTag()));
        }
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        return (AgeableMob)ModEntities.QUACKLING.get().m_20615_((Level)world);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        AnimationBuilder builder = new AnimationBuilder();
        if (this.isFishing()) {
            builder.addAnimation("fishing", Boolean.valueOf(true));
        } else if (event.isMoving()) {
            builder.addAnimation("walking", Boolean.valueOf(true));
        } else {
            builder.addAnimation("idle", Boolean.valueOf(true));
        }
        event.getController().setAnimation(builder);
        return PlayState.CONTINUE;
    }

    public boolean m_8023_() {
        return true;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 10.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    static class FishingGoal
    extends Goal {
        private final QuacklingEntity entity;

        public FishingGoal(QuacklingEntity entity) {
            this.entity = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.entity.isFishing();
        }
    }
}

