/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.duckling.common.constants;

import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import tech.thatgravyboat.duckling.Duckling;

public enum DuckVariant {
    AGENTD(0, Duckling.modId("textures/entity/agent_d.png")),
    MALLARD(1, Duckling.modId("textures/entity/mallard.png")),
    PEKIN(2, Duckling.modId("textures/entity/duck.png"));

    public final byte id;
    public final ResourceLocation texture;

    private DuckVariant(int id, ResourceLocation texture) {
        this((byte)id, texture);
    }

    private DuckVariant(byte id, ResourceLocation texture) {
        this.id = id;
        this.texture = texture;
    }

    public static DuckVariant getVariant(byte id) {
        for (DuckVariant value : DuckVariant.values()) {
            if (value.id != id) continue;
            return value;
        }
        return PEKIN;
    }

    public static DuckVariant getVariant(String id) {
        try {
            return DuckVariant.valueOf(id.toUpperCase(Locale.ROOT));
        }
        catch (Exception e) {
            return PEKIN;
        }
    }
}

