/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.SortOrder;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.security.ISecurityService;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.api.util.DimensionalBlockPos;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.hooks.ticking.TickHandler;
import appeng.me.GridNode;
import appeng.util.BlockUpdate;
import appeng.util.helpers.P2PHelper;
import appeng.util.prioritylist.IPartitionList;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import org.jetbrains.annotations.Nullable;

public class Platform {
    @VisibleForTesting
    public static ThreadGroup serverThreadGroup = SidedThreadGroups.SERVER;
    private static final Random RANDOM_GENERATOR = new Random();
    private static final WeakHashMap<Level, FakePlayer> FAKE_PLAYERS = new WeakHashMap();
    private static final P2PHelper P2P_HELPER = new P2PHelper();
    public static final Direction[] DIRECTIONS_WITH_NULL = new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, null};
    @Nullable
    private static final Class<?> ponderLevelClass = Platform.findPonderLevelClass("com.simibubi.create.foundation.ponder.PonderWorld");

    private static Class<?> findPonderLevelClass(String className) {
        if (!Platform.hasClientClasses()) {
            return null;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ignored) {
            AELog.warn("Unable to find class %s. Integration with PonderJS disabled.", className);
            return null;
        }
    }

    public static P2PHelper p2p() {
        return P2P_HELPER;
    }

    public static Random getRandom() {
        return RANDOM_GENERATOR;
    }

    public static float getRandomFloat() {
        return RANDOM_GENERATOR.nextFloat();
    }

    public static String formatPowerLong(long n, boolean isRate) {
        return Platform.formatPower((double)n / 100.0, isRate);
    }

    public static String formatPower(double p, boolean isRate) {
        PowerUnits displayUnits = AEConfig.instance().getSelectedPowerUnit();
        p = PowerUnits.AE.convertTo(displayUnits, p);
        String[] preFixes = new String[]{"k", "M", "G", "T", "P", "T", "P", "E", "Z", "Y"};
        String unitName = displayUnits.getSymbolName();
        String level = "";
        for (int offset = 0; p > 1000.0 && offset < preFixes.length; p /= 1000.0, ++offset) {
            level = preFixes[offset];
        }
        DecimalFormat df = new DecimalFormat("#.##");
        return df.format(p) + " " + level + unitName + (isRate ? "/t" : "");
    }

    public static String formatTimeMeasurement(long nanos) {
        if (nanos <= 0L) {
            return "0 ns";
        }
        if (nanos < 1000L) {
            return "<1 \u00b5s";
        }
        if (nanos <= 1000000L) {
            long ms = TimeUnit.MICROSECONDS.convert(nanos, TimeUnit.NANOSECONDS);
            return ms + "\u00b5s";
        }
        long ms = TimeUnit.MILLISECONDS.convert(nanos, TimeUnit.NANOSECONDS);
        return ms + "ms";
    }

    public static Direction crossProduct(Direction forward, Direction up) {
        int west_x = forward.m_122430_() * up.m_122431_() - forward.m_122431_() * up.m_122430_();
        int west_y = forward.m_122431_() * up.m_122429_() - forward.m_122429_() * up.m_122431_();
        int west_z = forward.m_122429_() * up.m_122430_() - forward.m_122430_() * up.m_122429_();
        return switch (west_x + west_y * 2 + west_z * 3) {
            case 1 -> Direction.EAST;
            case -1 -> Direction.WEST;
            case 2 -> Direction.UP;
            case -2 -> Direction.DOWN;
            case 3 -> Direction.SOUTH;
            case -3 -> Direction.NORTH;
            default -> Direction.NORTH;
        };
    }

    public static boolean hasClientClasses() {
        return FMLEnvironment.dist == null || FMLEnvironment.dist.isClient();
    }

    public static boolean isClient() {
        return Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER;
    }

    public static boolean hasPermissions(DimensionalBlockPos dc, Player player) {
        if (!dc.isInWorld((LevelAccessor)player.f_19853_)) {
            return false;
        }
        return player.f_19853_.m_7966_(player, dc.getPos());
    }

    public static boolean checkPermissions(Player player, IActionHost actionHost, SecurityPermissions requiredPermission, boolean requirePower, boolean notifyPlayer) {
        IGridNode gn = actionHost.getActionableNode();
        if (gn != null) {
            IEnergyService eg;
            IGrid g = gn.getGrid();
            if (requirePower && !(eg = g.getEnergyService()).isNetworkPowered()) {
                return false;
            }
            ISecurityService sg = g.getSecurityService();
            if (!sg.hasPermission(player, requiredPermission)) {
                if (notifyPlayer) {
                    player.m_6352_((Component)new TranslatableComponent("ae2.permission_denied").m_130940_(ChatFormatting.RED), Util.f_137441_);
                }
                return false;
            }
        }
        return true;
    }

    public static ItemStack[] getBlockDrops(Level level, BlockPos pos) {
        if (!(level instanceof ServerLevel)) {
            return new ItemStack[0];
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockState state = level.m_8055_(pos);
        BlockEntity blockEntity = level.m_7702_(pos);
        List out = Block.m_49869_((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)blockEntity);
        return out.toArray(new ItemStack[0]);
    }

    public static void spawnDrops(Level level, BlockPos pos, List<ItemStack> drops) {
        if (!level.m_5776_()) {
            for (ItemStack i : drops) {
                if (i.m_41619_() || i.m_41613_() <= 0) continue;
                double offset_x = (double)(Platform.getRandomInt() % 32 - 16) / 82.0;
                double offset_y = (double)(Platform.getRandomInt() % 32 - 16) / 82.0;
                double offset_z = (double)(Platform.getRandomInt() % 32 - 16) / 82.0;
                ItemEntity ei = new ItemEntity(level, 0.5 + offset_x + (double)pos.m_123341_(), 0.5 + offset_y + (double)pos.m_123342_(), 0.2 + offset_z + (double)pos.m_123343_(), i.m_41777_());
                level.m_7967_((Entity)ei);
            }
        }
    }

    public static boolean isServer() {
        return Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER;
    }

    public static void assertServerThread() {
        if (Thread.currentThread().getThreadGroup() != serverThreadGroup) {
            throw new UnsupportedOperationException("This code can only be called server-side and this is most likely a bug.");
        }
    }

    public static int getRandomInt() {
        return Math.abs(RANDOM_GENERATOR.nextInt());
    }

    public static String formatModName(String modId) {
        return ChatFormatting.BLUE + ChatFormatting.ITALIC + Platform.getModName(modId);
    }

    @javax.annotation.Nullable
    public static String getModName(String modId) {
        return ModList.get().getModContainerById(modId).map(mc -> mc.getModInfo().getDisplayName()).orElse(modId);
    }

    public static String getDescriptionId(Fluid fluid) {
        return fluid.m_76145_().m_76188_().m_60734_().m_7705_();
    }

    public static String getDescriptionId(FluidStack fluid) {
        return fluid.getDisplayName().getString();
    }

    public static Component getFluidDisplayName(Fluid fluid, @javax.annotation.Nullable CompoundTag tag) {
        FluidStack fluidStack = new FluidStack(fluid, 1);
        fluidStack.setTag(tag);
        return fluidStack.getDisplayName();
    }

    public static Component getItemDisplayName(Item item, @javax.annotation.Nullable CompoundTag tag) {
        ItemStack itemStack = new ItemStack((ItemLike)item);
        itemStack.m_41751_(tag);
        return itemStack.m_41786_();
    }

    public static boolean isChargeable(ItemStack i) {
        if (i.m_41619_()) {
            return false;
        }
        Item item = i.m_41720_();
        if (item instanceof IAEItemPowerStorage) {
            IAEItemPowerStorage powerStorage = (IAEItemPowerStorage)item;
            return powerStorage.getAEMaxPower(i) > 0.0 && powerStorage.getPowerFlow(i) != AccessRestriction.READ;
        }
        return false;
    }

    public static Player getPlayer(ServerLevel level) {
        Objects.requireNonNull(level);
        FakePlayer wrp = FAKE_PLAYERS.get(level);
        if (wrp != null) {
            return wrp;
        }
        FakePlayer p = FakePlayerFactory.getMinecraft((ServerLevel)level);
        FAKE_PLAYERS.put((Level)level, p);
        return p;
    }

    @javax.annotation.Nullable
    public static <T> T pickRandom(Collection<T> outs) {
        if (outs.isEmpty()) {
            return null;
        }
        int index = RANDOM_GENERATOR.nextInt(outs.size());
        return (T)Iterables.get(outs, (int)index, null);
    }

    public static Direction rotateAround(Direction forward, Direction axis) {
        if (forward.m_122434_() == axis.m_122434_()) {
            return forward;
        }
        Vec3i newForward = forward.m_122436_().m_7724_(axis.m_122436_());
        return Objects.requireNonNull(Direction.m_175360_((BlockPos)new BlockPos(newForward)));
    }

    public static boolean securityCheck(GridNode a, GridNode b) {
        boolean b_isSecure;
        if (a.getLastSecurityKey() == -1L && b.getLastSecurityKey() == -1L || a.getLastSecurityKey() == b.getLastSecurityKey()) {
            return true;
        }
        boolean a_isSecure = a.isPowered() && a.getLastSecurityKey() != -1L;
        boolean bl = b_isSecure = b.isPowered() && b.getLastSecurityKey() != -1L;
        if (AEConfig.instance().isSecurityAuditLogEnabled()) {
            AELog.info("Audit: Node A [isSecure=%b, key=%d, playerID=%d, %s] vs Node B[isSecure=%b, key=%d, playerID=%d, %s]", a_isSecure, a.getLastSecurityKey(), a.getOwningPlayerId(), a, b_isSecure, b.getLastSecurityKey(), b.getOwningPlayerId(), b);
        }
        if (a_isSecure && b_isSecure) {
            return false;
        }
        if (!a_isSecure && b_isSecure) {
            return Platform.checkPlayerPermissions(b.getGrid(), a.getOwningPlayerId());
        }
        if (a_isSecure && !b_isSecure) {
            return Platform.checkPlayerPermissions(a.getGrid(), b.getOwningPlayerId());
        }
        return true;
    }

    private static boolean checkPlayerPermissions(IGrid grid, int playerID) {
        if (grid == null) {
            return true;
        }
        ISecurityService gs = grid.getSecurityService();
        return !gs.isAvailable() || gs.hasPermission(playerID, SecurityPermissions.BUILD);
    }

    public static void configurePlayer(Player player, Direction side, BlockEntity blockEntity) {
        float pitch = 0.0f;
        float yaw = 0.0f;
        switch (side) {
            case DOWN: 
            case UP: {
                pitch = 90.0f;
                break;
            }
            case EAST: {
                yaw = -90.0f;
                break;
            }
            case NORTH: {
                yaw = 180.0f;
                break;
            }
            case SOUTH: {
                yaw = 0.0f;
                break;
            }
            case WEST: {
                yaw = 90.0f;
                break;
            }
        }
        player.m_7678_((double)blockEntity.m_58899_().m_123341_() + 0.5, (double)blockEntity.m_58899_().m_123342_() + 0.5, (double)blockEntity.m_58899_().m_123343_() + 0.5, yaw, pitch);
    }

    public static boolean canAccess(IManagedGridNode gridProxy, IActionSource src) {
        IGrid grid = gridProxy.getGrid();
        if (grid == null) {
            return false;
        }
        if (src.player().isPresent()) {
            return grid.getSecurityService().hasPermission(src.player().get(), SecurityPermissions.BUILD);
        }
        if (src.machine().isPresent()) {
            IActionHost te = src.machine().get();
            IGridNode n = te.getActionableNode();
            if (n == null) {
                return false;
            }
            int playerID = n.getOwningPlayerId();
            return grid.getSecurityService().hasPermission(playerID, SecurityPermissions.BUILD);
        }
        return grid.getSecurityService().hasPermission(-1, SecurityPermissions.BUILD);
    }

    public static ItemStack extractItemsByRecipe(IEnergySource energySrc, IActionSource mySrc, MEStorage src, Level level, Recipe<CraftingContainer> r, ItemStack output, CraftingContainer ci, ItemStack providedTemplate, int slot, KeyCounter items, Actionable realForFake, IPartitionList filter) {
        if (energySrc.extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 0.9) {
            boolean checkFuzzy;
            long extracted;
            if (providedTemplate == null) {
                return ItemStack.f_41583_;
            }
            AEItemKey ae_req = AEItemKey.of(providedTemplate);
            if ((filter == null || filter.isListed(ae_req)) && (extracted = src.extract(ae_req, 1L, realForFake, mySrc)) > 0L) {
                energySrc.extractAEPower(1.0, realForFake, PowerMultiplier.CONFIG);
                return ae_req.toStack();
            }
            boolean bl = checkFuzzy = providedTemplate.m_41782_() || providedTemplate.m_41763_();
            if (items != null && checkFuzzy) {
                for (Object2LongMap.Entry<AEKey> x : items) {
                    long ex;
                    Object object = x.getKey();
                    if (!(object instanceof AEItemKey)) continue;
                    AEItemKey itemKey = (AEItemKey)object;
                    if (providedTemplate.m_41720_() != itemKey.getItem() || itemKey.matches(output)) continue;
                    ci.m_6836_(slot, itemKey.toStack());
                    if (r.m_5818_((Container)ci, level) && ItemStack.m_41746_((ItemStack)r.m_5874_((Container)ci), (ItemStack)output) && (filter == null || filter.isListed(itemKey)) && (ex = src.extract(itemKey, 1L, realForFake, mySrc)) > 0L) {
                        energySrc.extractAEPower(1.0, realForFake, PowerMultiplier.CONFIG);
                        return itemKey.toStack();
                    }
                    ci.m_6836_(slot, providedTemplate);
                }
            }
        }
        return ItemStack.f_41583_;
    }

    public static void notifyBlocksOfNeighbors(Level level, BlockPos pos) {
        if (level != null && !level.f_46443_) {
            TickHandler.instance().addCallable((LevelAccessor)level, new BlockUpdate(pos));
        }
    }

    public static boolean isSortOrderAvailable(SortOrder order) {
        return true;
    }

    @javax.annotation.Nullable
    public static BlockEntity getTickingBlockEntity(@javax.annotation.Nullable Level level, BlockPos pos) {
        if (!Platform.areBlockEntitiesTicking(level, pos)) {
            return null;
        }
        return level.m_7702_(pos);
    }

    public static boolean areBlockEntitiesTicking(@javax.annotation.Nullable Level level, BlockPos pos) {
        return Platform.areBlockEntitiesTicking(level, ChunkPos.m_151388_((BlockPos)pos));
    }

    public static boolean areBlockEntitiesTicking(@javax.annotation.Nullable Level level, long chunkPos) {
        ServerLevel serverLevel;
        return level instanceof ServerLevel && (serverLevel = (ServerLevel)level).m_7726_().m_143239_(chunkPos);
    }

    public static boolean canItemStacksStack(ItemStack a, ItemStack b) {
        if (a.m_41619_() || !a.m_41656_(b) || a.m_41782_() != b.m_41782_()) {
            return false;
        }
        return !a.m_41782_() || a.m_41783_().equals((Object)b.m_41783_());
    }

    public static Packet<?> getFullChunkPacket(LevelChunk c) {
        return new ClientboundLevelChunkWithLightPacket(c, c.m_62953_().m_5518_(), null, null, true);
    }

    public static ItemStack getInsertionRemainder(ItemStack original, long inserted) {
        if (inserted >= (long)original.m_41613_()) {
            return ItemStack.f_41583_;
        }
        return Platform.copyStackWithSize(original, (int)((long)original.m_41613_() - inserted));
    }

    public static ItemStack copyStackWithSize(ItemStack itemStack, int size) {
        if (size <= 0) {
            return ItemStack.f_41583_;
        }
        ItemStack copy = itemStack.m_41777_();
        copy.m_41764_(size);
        return copy;
    }

    public static void sendImmediateBlockEntityUpdate(Player player, BlockPos pos) {
        if (player instanceof ServerPlayer) {
            Packet packet;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockEntity be = player.m_183503_().m_7702_(pos);
            if (be != null && (packet = be.m_183216_()) != null) {
                serverPlayer.f_8906_.m_141995_(packet);
            }
        }
    }

    public static boolean isPonderLevel(Level level) {
        return ponderLevelClass != null && ponderLevelClass.isInstance(level);
    }

    public static boolean isDevelopmentEnvironment() {
        return !FMLEnvironment.production;
    }
}

