/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.testworld;

import appeng.server.testplots.TestPlots;
import appeng.server.testworld.Plot;
import appeng.server.testworld.PlotTestHelper;
import appeng.server.testworld.Test;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.gametest.framework.GameTestGenerator;
import net.minecraft.gametest.framework.TestFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class GameTestPlotAdapter {
    @GameTestGenerator
    public List<TestFunction> gameTestAdapter() {
        ArrayList<TestFunction> result = new ArrayList<TestFunction>();
        for (Plot plot : TestPlots.createPlots()) {
            Test test = plot.getTest();
            if (test == null) continue;
            result.add(new TestFunction("ae2", "ae2." + plot.getId().m_135815_(), plot.getId().toString(), Rotation.NONE, test.maxTicks, (long)test.setupTicks, true, 1, 1, gameTestHelper -> test.getTestFunction().accept(new PlotTestHelper(GameTestPlotAdapter.getPlotTranslation(plot.getBounds()), gameTestHelper.f_127595_))));
        }
        return result;
    }

    public static StructureTemplate getStructureTemplate(String structureName) {
        ResourceLocation id = ResourceLocation.m_135820_((String)structureName);
        if (id == null) {
            return null;
        }
        Plot plot = TestPlots.getById(id);
        if (plot != null) {
            StructureTemplate template = new StructureTemplate();
            CompoundTag tag = new CompoundTag();
            ListTag sizeList = new ListTag();
            BoundingBox bounds = plot.getBounds();
            sizeList.add((Object)IntTag.m_128679_((int)bounds.m_71056_()));
            sizeList.add((Object)IntTag.m_128679_((int)bounds.m_71057_()));
            sizeList.add((Object)IntTag.m_128679_((int)bounds.m_71058_()));
            tag.m_128365_("size", (Tag)sizeList);
            template.m_74638_(tag);
            return template;
        }
        return null;
    }

    public static void createStructure(StructureBlockEntity structureBlock) {
        ResourceLocation id = ResourceLocation.m_135820_((String)structureBlock.m_59895_());
        if (id == null) {
            return;
        }
        Plot plot = TestPlots.getById(id);
        if (plot != null) {
            BoundingBox bounds = plot.getBounds();
            BlockPos origin = structureBlock.m_58899_().m_141952_((Vec3i)structureBlock.m_59902_()).m_141952_((Vec3i)GameTestPlotAdapter.getPlotTranslation(bounds));
            ServerLevel level = (ServerLevel)structureBlock.m_58904_();
            plot.build(level, Platform.getPlayer(level), origin);
        }
    }

    private static BlockPos getPlotTranslation(BoundingBox bounds) {
        return new BlockPos(bounds.m_162395_() < 0 ? -bounds.m_162395_() : 0, bounds.m_162396_() < 0 ? -bounds.m_162396_() : 0, bounds.m_162398_() < 0 ? -bounds.m_162398_() : 0);
    }
}

