/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.style;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class Blitter {
    public static final int DEFAULT_TEXTURE_WIDTH = 256;
    public static final int DEFAULT_TEXTURE_HEIGHT = 256;
    private final ResourceLocation texture;
    private final int referenceWidth;
    private final int referenceHeight;
    private int r = 255;
    private int g = 255;
    private int b = 255;
    private int a = 255;
    private Rect2i srcRect;
    private Rect2i destRect = new Rect2i(0, 0, 0, 0);
    private boolean blending = true;

    Blitter(ResourceLocation texture, int referenceWidth, int referenceHeight) {
        this.texture = texture;
        this.referenceWidth = referenceWidth;
        this.referenceHeight = referenceHeight;
    }

    public static Blitter texture(ResourceLocation file) {
        return Blitter.texture(file, 256, 256);
    }

    public static Blitter texture(String file) {
        return Blitter.texture(file, 256, 256);
    }

    public static Blitter texture(ResourceLocation file, int referenceWidth, int referenceHeight) {
        return new Blitter(file, referenceWidth, referenceHeight);
    }

    public static Blitter texture(String file, int referenceWidth, int referenceHeight) {
        return new Blitter(new ResourceLocation("ae2", "textures/" + file), referenceWidth, referenceHeight);
    }

    public static Blitter sprite(TextureAtlasSprite sprite) {
        int refSize = 0x3FFFFFFF;
        TextureAtlas atlas = sprite.m_118414_();
        return new Blitter(atlas.m_118330_(), 0x3FFFFFFF, 0x3FFFFFFF).src((int)(sprite.m_118409_() * 1.0737418E9f), (int)(sprite.m_118411_() * 1.0737418E9f), (int)((sprite.m_118410_() - sprite.m_118409_()) * 1.0737418E9f), (int)((sprite.m_118412_() - sprite.m_118411_()) * 1.0737418E9f));
    }

    public Blitter copy() {
        Blitter result = new Blitter(this.texture, this.referenceWidth, this.referenceHeight);
        result.srcRect = this.srcRect;
        result.destRect = this.destRect;
        result.r = this.r;
        result.g = this.g;
        result.b = this.b;
        result.a = this.a;
        return result;
    }

    public int getSrcX() {
        return this.srcRect == null ? 0 : this.srcRect.m_110085_();
    }

    public int getSrcY() {
        return this.srcRect == null ? 0 : this.srcRect.m_110086_();
    }

    public int getSrcWidth() {
        return this.srcRect == null ? this.destRect.m_110090_() : this.srcRect.m_110090_();
    }

    public int getSrcHeight() {
        return this.srcRect == null ? this.destRect.m_110091_() : this.srcRect.m_110091_();
    }

    public Blitter src(int x, int y, int w, int h) {
        this.srcRect = new Rect2i(x, y, w, h);
        return this;
    }

    public Blitter srcWidth(int w) {
        this.srcRect = new Rect2i(this.srcRect.m_110085_(), this.srcRect.m_110086_(), w, this.srcRect.m_110091_());
        return this;
    }

    public Blitter srcHeight(int h) {
        this.srcRect = new Rect2i(this.srcRect.m_110085_(), this.srcRect.m_110086_(), this.srcRect.m_110090_(), h);
        return this;
    }

    public Blitter src(Rect2i rect) {
        return this.src(rect.m_110085_(), rect.m_110086_(), rect.m_110090_(), rect.m_110091_());
    }

    public Blitter dest(int x, int y, int w, int h) {
        this.destRect = new Rect2i(x, y, w, h);
        return this;
    }

    public Blitter dest(int x, int y) {
        return this.dest(x, y, 0, 0);
    }

    public Blitter dest(Rect2i rect) {
        return this.dest(rect.m_110085_(), rect.m_110086_(), rect.m_110090_(), rect.m_110091_());
    }

    public Rect2i getDestRect() {
        int x = this.destRect.m_110085_();
        int y = this.destRect.m_110086_();
        int w = 0;
        int h = 0;
        if (this.destRect.m_110090_() != 0 && this.destRect.m_110091_() != 0) {
            w = this.destRect.m_110090_();
            h = this.destRect.m_110091_();
        } else if (this.srcRect != null) {
            w = this.srcRect.m_110090_();
            h = this.srcRect.m_110091_();
        }
        return new Rect2i(x, y, w, h);
    }

    public Blitter color(float r, float g, float b) {
        this.r = (int)(Mth.m_14036_((float)r, (float)0.0f, (float)1.0f) * 255.0f);
        this.g = (int)(Mth.m_14036_((float)g, (float)0.0f, (float)1.0f) * 255.0f);
        this.b = (int)(Mth.m_14036_((float)b, (float)0.0f, (float)1.0f) * 255.0f);
        return this;
    }

    public Blitter opacity(float a) {
        this.a = (int)(Mth.m_14036_((float)a, (float)0.0f, (float)1.0f) * 255.0f);
        return this;
    }

    public Blitter color(float r, float g, float b, float a) {
        return this.color(r, g, b).opacity(a);
    }

    public Blitter blending(boolean enable) {
        this.blending = enable;
        return this;
    }

    public Blitter colorRgb(int packedRgb) {
        float r = (float)(packedRgb >> 16 & 0xFF) / 255.0f;
        float g = (float)(packedRgb >> 8 & 0xFF) / 255.0f;
        float b = (float)(packedRgb & 0xFF) / 255.0f;
        return this.color(r, g, b);
    }

    public void blit(int zIndex) {
        this.blit(new PoseStack(), zIndex);
    }

    public void blit(PoseStack poseStack, int zIndex) {
        float maxU;
        float maxV;
        float minU;
        float minV;
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
        if (this.srcRect == null) {
            minV = 0.0f;
            minU = 0.0f;
            maxV = 1.0f;
            maxU = 1.0f;
        } else {
            minU = (float)this.srcRect.m_110085_() / (float)this.referenceWidth;
            minV = (float)this.srcRect.m_110086_() / (float)this.referenceHeight;
            maxU = (float)(this.srcRect.m_110085_() + this.srcRect.m_110090_()) / (float)this.referenceWidth;
            maxV = (float)(this.srcRect.m_110086_() + this.srcRect.m_110091_()) / (float)this.referenceHeight;
        }
        float x1 = this.destRect.m_110085_();
        float y1 = this.destRect.m_110086_();
        float x2 = x1;
        float y2 = y1;
        if (this.destRect.m_110090_() != 0 && this.destRect.m_110091_() != 0) {
            x2 += (float)this.destRect.m_110090_();
            y2 += (float)this.destRect.m_110091_();
        } else if (this.srcRect != null) {
            x2 += (float)this.srcRect.m_110090_();
            y2 += (float)this.srcRect.m_110091_();
        }
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferbuilder.m_85982_(matrix, x1, y2, (float)zIndex).m_7421_(minU, maxV).m_6122_(this.r, this.g, this.b, this.a).m_5752_();
        bufferbuilder.m_85982_(matrix, x2, y2, (float)zIndex).m_7421_(maxU, maxV).m_6122_(this.r, this.g, this.b, this.a).m_5752_();
        bufferbuilder.m_85982_(matrix, x2, y1, (float)zIndex).m_7421_(maxU, minV).m_6122_(this.r, this.g, this.b, this.a).m_5752_();
        bufferbuilder.m_85982_(matrix, x1, y1, (float)zIndex).m_7421_(minU, minV).m_6122_(this.r, this.g, this.b, this.a).m_5752_();
        bufferbuilder.m_85721_();
        if (this.blending) {
            RenderSystem.m_69478_();
            RenderSystem.m_69405_((int)770, (int)771);
        } else {
            RenderSystem.m_69461_();
        }
        RenderSystem.m_69493_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
    }
}

