/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.misc;

import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.misc.SkyCompassBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SkyCompassBlock
extends AEBaseEntityBlock<SkyCompassBlockEntity>
implements SimpleWaterloggedBlock {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public SkyCompassBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public boolean isValidOrientation(LevelAccessor level, BlockPos pos, Direction forward, Direction up) {
        SkyCompassBlockEntity sc = (SkyCompassBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (sc != null) {
            return false;
        }
        return this.canPlaceAt((BlockGetter)level, pos, forward.m_122424_());
    }

    private boolean canPlaceAt(BlockGetter level, BlockPos pos, Direction dir) {
        BlockPos test = pos.m_142300_(dir);
        BlockState blockstate = level.m_8055_(test);
        return blockstate.m_60783_(level, test, dir.m_122424_());
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        SkyCompassBlockEntity sc = (SkyCompassBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        Direction forward = sc.getForward();
        if (!this.canPlaceAt((BlockGetter)level, pos, forward.m_122424_()) || !this.m_5888_(state).m_76170_()) {
            this.dropTorch(level, pos);
        }
    }

    private void dropTorch(Level level, BlockPos pos) {
        BlockState prev = level.m_8055_(pos);
        level.m_46961_(pos, true);
        level.m_7260_(pos, prev, level.m_8055_(pos), 3);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        for (Direction dir : Direction.values()) {
            if (!this.canPlaceAt((BlockGetter)level, pos, dir)) continue;
            return true;
        }
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        SkyCompassBlockEntity blockEntity = (SkyCompassBlockEntity)this.getBlockEntity(level, pos);
        if (blockEntity != null) {
            Direction forward = blockEntity.getForward();
            double minX = 0.0;
            double minY = 0.0;
            double minZ = 0.0;
            double maxX = 1.0;
            double maxY = 1.0;
            double maxZ = 1.0;
            switch (forward) {
                case DOWN: {
                    minX = 0.3125;
                    minZ = 0.3125;
                    maxX = 0.6875;
                    maxZ = 0.6875;
                    maxY = 1.0;
                    minY = 0.875;
                    break;
                }
                case EAST: {
                    minY = 0.3125;
                    minZ = 0.3125;
                    maxY = 0.6875;
                    maxZ = 0.6875;
                    maxX = 0.125;
                    minX = 0.0;
                    break;
                }
                case NORTH: {
                    minX = 0.3125;
                    minY = 0.3125;
                    maxX = 0.6875;
                    maxY = 0.6875;
                    maxZ = 1.0;
                    minZ = 0.875;
                    break;
                }
                case SOUTH: {
                    minX = 0.3125;
                    minY = 0.3125;
                    maxX = 0.6875;
                    maxY = 0.6875;
                    maxZ = 0.125;
                    minZ = 0.0;
                    break;
                }
                case UP: {
                    minX = 0.3125;
                    minZ = 0.3125;
                    maxX = 0.6875;
                    maxZ = 0.6875;
                    maxY = 0.125;
                    minY = 0.0;
                    break;
                }
                case WEST: {
                    minY = 0.3125;
                    minZ = 0.3125;
                    maxY = 0.6875;
                    maxZ = 0.6875;
                    maxX = 1.0;
                    minX = 0.875;
                    break;
                }
            }
            return Shapes.m_83064_((AABB)new AABB(minX, minY, minZ, maxX, maxY, maxZ));
        }
        return Shapes.m_83040_();
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        FluidState fluidState = context.m_43725_().m_6425_(pos);
        BlockState blockState = (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        return blockState;
    }

    public FluidState m_5888_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }

    public BlockState m_7417_(BlockState blockState, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(blockState, facing, facingState, level, currentPos, facingPos);
    }
}

