/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model.pipeline;

import codechicken.lib.model.CachedFormat;
import codechicken.lib.model.ISmartVertexConsumer;
import codechicken.lib.model.Quad;
import codechicken.lib.model.pipeline.IPipelineConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;

public abstract class QuadTransformer
implements IVertexConsumer,
ISmartVertexConsumer,
IPipelineConsumer {
    protected final Quad quad;
    protected CachedFormat format;
    protected IVertexConsumer consumer;
    private static final double EPSILON = 1.0E-5;

    protected QuadTransformer() {
        this.quad = new Quad();
    }

    public QuadTransformer(IVertexConsumer consumer) {
        this(consumer.getVertexFormat(), consumer);
    }

    public QuadTransformer(VertexFormat format, IVertexConsumer consumer) {
        this(CachedFormat.lookup(format), consumer);
    }

    public QuadTransformer(CachedFormat format, IVertexConsumer consumer) {
        this.format = format;
        this.consumer = consumer;
        this.quad = new Quad(format);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void reset(CachedFormat format) {
        this.format = format;
        this.quad.reset(format);
    }

    @Override
    public void setParent(IVertexConsumer parent) {
        this.consumer = parent;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void setInputQuad(Quad quad) {
        if (this.consumer instanceof IPipelineConsumer) {
            ((IPipelineConsumer)this.consumer).setInputQuad(quad);
        }
    }

    public VertexFormat getVertexFormat() {
        return this.format.format;
    }

    public void setQuadTint(int tint) {
        this.quad.setQuadTint(tint);
    }

    public void setQuadOrientation(Direction orientation) {
        this.quad.setQuadOrientation(orientation);
    }

    public void setApplyDiffuseLighting(boolean diffuse) {
        this.quad.setApplyDiffuseLighting(diffuse);
    }

    public void setTexture(TextureAtlasSprite texture) {
        this.quad.setTexture(texture);
    }

    public void put(int element, float ... data) {
        this.quad.put(element, data);
        if (this.quad.full) {
            this.onFull();
        }
    }

    @Override
    public void put(Quad quad) {
        this.quad.put(quad);
        this.onFull();
    }

    public abstract boolean transform();

    public void onFull() {
        if (this.transform()) {
            this.quad.pipe(this.consumer);
        }
    }

    public static boolean epsComp(float a, float b) {
        if (a == b) {
            return true;
        }
        return (double)Math.abs(a - b) < 1.0E-5;
    }
}

