/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model.bakedmodels;

import codechicken.lib.model.CachedFormat;
import codechicken.lib.model.bakedmodels.ModelProperties;
import codechicken.lib.render.particle.IModelParticleProvider;
import codechicken.lib.vec.Vector3;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.LightUtil;

public abstract class AbstractBakedPropertiesModel
implements IModelParticleProvider,
BakedModel {
    protected final ModelProperties properties;

    public AbstractBakedPropertiesModel(ModelProperties properties) {
        this.properties = properties;
    }

    public boolean m_7541_() {
        return this.properties.isAmbientOcclusion();
    }

    public boolean m_7539_() {
        return this.properties.isGui3d();
    }

    public boolean m_7521_() {
        return this.properties.isBuiltInRenderer();
    }

    public boolean m_7547_() {
        return this.properties.usesBlockLight();
    }

    @Override
    public TextureAtlasSprite m_6160_() {
        return this.properties.getParticleTexture();
    }

    protected List<BakedQuad> getAllQuads(BlockState state, IModelData modelData) {
        LinkedList<BakedQuad> allQuads = new LinkedList<BakedQuad>();
        allQuads.addAll(this.getQuads(state, null, new Random(0L), modelData));
        for (Direction face : Direction.f_122348_) {
            allQuads.addAll(this.getQuads(state, face, new Random(0L), modelData));
        }
        return allQuads;
    }

    @Override
    public Set<TextureAtlasSprite> getHitEffects(@Nonnull BlockHitResult traceResult, BlockState state, BlockAndTintGetter world, BlockPos pos, IModelData modelData) {
        Vector3 vec = new Vector3(traceResult.m_82450_()).subtract(traceResult.m_82425_());
        return this.getAllQuads(state, modelData).stream().filter(quad -> quad.m_111306_() == traceResult.m_82434_()).filter(quad -> this.checkDepth((BakedQuad)quad, vec, traceResult.m_82434_())).map(BakedQuad::m_173410_).collect(Collectors.toSet());
    }

    protected boolean checkDepth(BakedQuad quad, Vector3 hit, Direction hitFace) {
        int[] quadData = quad.m_111303_();
        CachedFormat format = CachedFormat.lookup(DefaultVertexFormat.f_85811_);
        Vector3 posVec = new Vector3();
        float[] pos = new float[4];
        for (int v = 0; v < 4; ++v) {
            LightUtil.unpack((int[])quadData, (float[])pos, (VertexFormat)format.format, (int)v, (int)format.positionIndex);
            posVec.add(pos[0], pos[1], pos[2]);
        }
        posVec.divide(4.0);
        double diff = 0.0;
        switch (hitFace.m_122434_()) {
            case X: {
                diff = Math.abs(hit.x - posVec.x);
                break;
            }
            case Y: {
                diff = Math.abs(hit.y - posVec.y);
                break;
            }
            case Z: {
                diff = Math.abs(hit.z - posVec.z);
            }
        }
        return !(diff > 0.01);
    }

    @Override
    public Set<TextureAtlasSprite> getDestroyEffects(BlockState state, BlockAndTintGetter world, BlockPos pos, IModelData data) {
        return this.getAllQuads(state, data).stream().map(BakedQuad::m_173410_).collect(Collectors.toSet());
    }

    public boolean doesHandlePerspectives() {
        return true;
    }

    public BakedModel handlePerspective(ItemTransforms.TransformType transformType, PoseStack mat) {
        if (this.properties instanceof ModelProperties.PerspectiveProperties) {
            ModelState transforms = ((ModelProperties.PerspectiveProperties)this.properties).getTransforms();
            return PerspectiveMapWrapper.handlePerspective((BakedModel)this, (ModelState)transforms, (ItemTransforms.TransformType)transformType, (PoseStack)mat);
        }
        return IModelParticleProvider.super.handlePerspective(transformType, mat);
    }
}

