/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.render;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import org.embeddedt.modernfix.render.FastItemRenderType;
import org.jetbrains.annotations.Nullable;

public class SimpleItemModelView
implements BakedModel {
    private BakedModel wrappedItem;
    private FastItemRenderType type;
    private final List<BakedQuad> nullQuadList = new ObjectArrayList();

    public void setItem(BakedModel model) {
        this.wrappedItem = model;
    }

    public void setType(FastItemRenderType type) {
        this.type = type;
    }

    private boolean isCorrectDirectionForType(Direction direction) {
        if (this.type == FastItemRenderType.SIMPLE_ITEM) {
            return direction == Direction.SOUTH;
        }
        return direction == Direction.UP || direction == Direction.EAST || direction == Direction.NORTH;
    }

    public List<BakedQuad> m_6840_(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        boolean isWholeListValid = this.isCorrectDirectionForType(side);
        List realList = this.wrappedItem.m_6840_(state, side, rand);
        if (isWholeListValid) {
            return realList;
        }
        this.nullQuadList.clear();
        for (int i = 0; i < realList.size(); ++i) {
            BakedQuad quad = (BakedQuad)realList.get(i);
            if (!this.isCorrectDirectionForType(quad.m_111306_())) continue;
            this.nullQuadList.add(quad);
        }
        return this.nullQuadList;
    }

    public boolean m_7541_() {
        return this.wrappedItem.m_7541_();
    }

    public boolean m_7539_() {
        return this.wrappedItem.m_7539_();
    }

    public boolean m_7547_() {
        return this.wrappedItem.m_7547_();
    }

    public boolean m_7521_() {
        return this.wrappedItem.m_7521_();
    }

    public TextureAtlasSprite m_6160_() {
        return this.wrappedItem.m_6160_();
    }

    public ItemTransforms m_7442_() {
        return this.wrappedItem.m_7442_();
    }

    public ItemOverrides m_7343_() {
        return this.wrappedItem.m_7343_();
    }
}

