/*
 * Decompiled with CFR 0.152.
 */
package dzwdz.chat_heads;

import dzwdz.chat_heads.config.ChatHeadsConfig;
import dzwdz.chat_heads.config.ChatHeadsConfigDefaults;
import dzwdz.chat_heads.mixinterface.GuiMessageOwnerAccessor;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChatHeads {
    public static final String MOD_ID = "chat_heads";
    public static ChatHeadsConfig CONFIG = new ChatHeadsConfigDefaults();
    @Nullable
    public static PlayerInfo lastSender;
    @Nullable
    public static GuiMessage<?> lastGuiMessage;
    public static int lastY;
    public static float lastOpacity;
    public static int lastChatOffset;
    public static boolean serverSentUuid;

    public static int getChatOffset(@NotNull GuiMessage<?> guiMessage) {
        PlayerInfo owner = ((GuiMessageOwnerAccessor)guiMessage).chatheads$getOwner();
        return ChatHeads.getChatOffset(owner);
    }

    public static int getChatOffset(@Nullable PlayerInfo owner) {
        if (owner != null || CONFIG.offsetNonPlayerText()) {
            return 10;
        }
        return 0;
    }

    @Nullable
    public static PlayerInfo detectPlayer(ClientPacketListener connection, Component message) {
        HashMap<String, PlayerInfo> nicknameCache = new HashMap<String, PlayerInfo>();
        for (String word : message.getString().split("(\u00a7.)|[^\\w]")) {
            if (word.isEmpty()) continue;
            PlayerInfo player = connection.m_104938_(word);
            if (player != null) {
                return player;
            }
            player = ChatHeads.getPlayerFromNickname(word, connection, nicknameCache);
            if (player == null) continue;
            return player;
        }
        return null;
    }

    @Nullable
    private static PlayerInfo getPlayerFromNickname(String word, ClientPacketListener connection, Map<String, PlayerInfo> nicknameCache) {
        if (nicknameCache.isEmpty()) {
            for (PlayerInfo p : connection.m_105142_()) {
                Component displayName = p.m_105342_();
                if (displayName == null) continue;
                String nickname = displayName.getString();
                if (word.equals(nickname)) {
                    nicknameCache.clear();
                    return p;
                }
                nicknameCache.put(nickname, p);
            }
        } else {
            return nicknameCache.get(word);
        }
        return null;
    }

    static {
        lastY = 0;
        lastOpacity = 0.0f;
        serverSentUuid = false;
    }
}

