/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.BlockEntityBaseWidget;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.gui.widget.premade.TextFieldWidget;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.Tesseract;
import com.supermartijn642.tesseract.TesseractBlockEntity;
import com.supermartijn642.tesseract.TesseractClient;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.TesseractChannelManager;
import com.supermartijn642.tesseract.packets.PacketScreenAddChannel;
import com.supermartijn642.tesseract.screen.LockButton;
import com.supermartijn642.tesseract.screen.TesseractButton;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class TesseractAddChannelScreen
extends BlockEntityBaseWidget<TesseractBlockEntity> {
    private static final int CHANNEL_MIN_CHARACTERS = 3;
    private static final int CHANNEL_MAX_CHARACTERS = 19;
    private static final ResourceLocation BACKGROUND = new ResourceLocation("tesseract", "textures/gui/add_screen_background.png");
    private final EnumChannelType type;
    private TextFieldWidget nameField;
    private TesseractButton addButton;
    private LockButton lockButton;

    protected TesseractAddChannelScreen(Level level, BlockPos pos, EnumChannelType type) {
        super(0, 0, 144, 65, level, pos);
        this.type = type;
    }

    protected void addWidgets(TesseractBlockEntity entity) {
        this.nameField = (TextFieldWidget)this.addWidget((Widget)new TextFieldWidget(7, 21, 107, 18, "", 19, this::checkChannelName));
        this.nameField.setSuggestion(ClientUtils.translate((String)"gui.tesseract.add.suggestion", (Object[])new Object[0]));
        this.addButton = (TesseractButton)this.addWidget((Widget)new TesseractButton(8, 43, 61, 14, (Component)TextComponents.translation((String)"gui.tesseract.add.add").get(), this::addChannel));
        this.addButton.active = false;
        TesseractButton cancelButton = (TesseractButton)this.addWidget((Widget)new TesseractButton(75, 43, 61, 14, (Component)TextComponents.translation((String)"gui.tesseract.add.cancel").get(), () -> TesseractClient.openScreen(this.blockEntityPos)));
        cancelButton.setRedBackground();
        this.lockButton = (LockButton)this.addWidget((Widget)new LockButton(117, 20));
        this.lockButton.setLocked(true);
        super.addWidgets((Object)entity);
    }

    protected void render(PoseStack matrixStack, int mouseX, int mouseY, TesseractBlockEntity entity) {
        ScreenUtils.bindTexture((ResourceLocation)BACKGROUND);
        ScreenUtils.drawTexture((PoseStack)matrixStack, (float)0.0f, (float)0.0f, (float)this.width(), (float)this.height());
        ScreenUtils.drawCenteredString((PoseStack)matrixStack, (Component)TextComponents.translation((String)("gui.tesseract.add.title." + this.type.name().toLowerCase(Locale.ROOT))).get(), (float)72.0f, (float)6.0f, (int)-1);
        super.render(matrixStack, mouseX, mouseY, (Object)entity);
    }

    private boolean checkChannelName(String name) {
        if ((name = name.trim()).length() < 3 || name.length() > 20) {
            this.addButton.active = false;
            return false;
        }
        List<Channel> channels = TesseractChannelManager.CLIENT.getChannelsCreatedBy(this.type, ClientUtils.getPlayer().m_142081_());
        boolean isUnique = true;
        for (Channel channel : channels) {
            if (!channel.name.equals(name)) continue;
            isUnique = false;
            break;
        }
        this.addButton.active = isUnique;
        return isUnique;
    }

    private void addChannel() {
        String name = this.nameField.getText().trim();
        if (!this.checkChannelName(name)) {
            return;
        }
        Tesseract.CHANNEL.sendToServer((BasePacket)new PacketScreenAddChannel(this.type, name, this.lockButton.isLocked()));
        TesseractClient.openScreen(this.blockEntityPos);
    }

    protected Component getNarrationMessage(TesseractBlockEntity object) {
        return TextComponents.translation((String)("gui.tesseract.add.title." + this.type.name().toLowerCase(Locale.ROOT))).get();
    }
}

