/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.manager;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.tesseract.TesseractConfig;
import com.supermartijn642.tesseract.manager.TesseractChannelManager;
import com.supermartijn642.tesseract.manager.TesseractTracker;
import java.nio.file.Path;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;

public class TesseractSaveHandler {
    private static long lastSaveTime = 0L;

    public static void registerListeners() {
        MinecraftForge.EVENT_BUS.addListener(TesseractSaveHandler::onJoin);
        MinecraftForge.EVENT_BUS.addListener(TesseractSaveHandler::tick);
        MinecraftForge.EVENT_BUS.addListener(TesseractSaveHandler::save);
        MinecraftForge.EVENT_BUS.addListener(TesseractSaveHandler::load);
    }

    private static void onJoin(PlayerEvent.PlayerLoggedInEvent e) {
        if (e.getEntity().m_20193_().f_46443_) {
            return;
        }
        TesseractTracker.sendReferences(e.getPlayer());
        TesseractChannelManager.sendChannels(e.getPlayer());
    }

    private static void tick(TickEvent.WorldTickEvent e) {
        if (e.world.f_46443_ || e.phase != TickEvent.Phase.END || e.world.m_46472_() != Level.f_46428_) {
            return;
        }
        if (System.currentTimeMillis() - lastSaveTime >= (long)(TesseractConfig.saveInterval.get() * 60000)) {
            Path saveDirectory = CommonUtils.getServer().m_129843_(LevelResource.f_78182_);
            TesseractTracker.saveReferences(saveDirectory);
            TesseractChannelManager.saveChannels(saveDirectory);
            lastSaveTime = System.currentTimeMillis();
        }
    }

    private static void save(WorldEvent.Save e) {
        if (e.getWorld().m_5776_() || !(e.getWorld() instanceof Level) || ((Level)e.getWorld()).m_46472_() != Level.f_46428_) {
            return;
        }
        Path saveDirectory = CommonUtils.getServer().m_129843_(LevelResource.f_78182_);
        TesseractTracker.saveReferences(saveDirectory);
        TesseractChannelManager.saveChannels(saveDirectory);
        lastSaveTime = System.currentTimeMillis();
    }

    private static void load(WorldEvent.Load e) {
        if (e.getWorld().m_5776_() || !(e.getWorld() instanceof Level) || ((Level)e.getWorld()).m_46472_() != Level.f_46428_) {
            return;
        }
        Path saveDirectory = CommonUtils.getServer().m_129843_(LevelResource.f_78182_);
        TesseractTracker.loadReferences(saveDirectory);
        TesseractChannelManager.loadChannels(saveDirectory);
        lastSaveTime = System.currentTimeMillis();
    }
}

