/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.mysticaloaktree.worldgen;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.OptionalInt;
import net.mehvahdjukaar.moonlight3.api.misc.RegSupplier;
import net.mehvahdjukaar.moonlight3.api.platform.RegHelper;
import net.mehvahdjukaar.mysticaloaktree.MysticalOakTree;
import net.mehvahdjukaar.mysticaloaktree.worldgen.BiomeMatchPredicate;
import net.mehvahdjukaar.mysticaloaktree.worldgen.WiseOakDecorator;
import net.mehvahdjukaar.mysticaloaktree.worldgen.WiseOakFeature;
import net.mehvahdjukaar.mysticaloaktree.worldgen.WiseOakFoliagePlacer;
import net.mehvahdjukaar.mysticaloaktree.worldgen.WiseOakTrunkPlacer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.LeaveVineDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import org.jetbrains.annotations.NotNull;

public class ModFeatures {
    public static final RegSupplier<BlockPredicateType<BiomeMatchPredicate>> BIOME_MATCH_PREDICATE = RegHelper.register(MysticalOakTree.res("biome_match"), () -> () -> BiomeMatchPredicate.CODEC, Registry.f_194566_);
    public static final RegSupplier<Feature<WiseOakFeature.Configuration>> WISE_OAK_FEATURE = RegHelper.registerFeature(MysticalOakTree.res("wise_oak_trunk_placer"), WiseOakFeature::new);
    public static final RegSupplier<TrunkPlacerType<WiseOakTrunkPlacer>> WISE_OAK_TRUNK_PLACER = RegHelper.register(MysticalOakTree.res("wise_oak_trunk_placer"), () -> new TrunkPlacerType(WiseOakTrunkPlacer.CODEC), Registry.f_122859_);
    public static final RegSupplier<FoliagePlacerType<WiseOakFoliagePlacer>> WISE_OAK_FOLIAGE_PLACER = RegHelper.register(MysticalOakTree.res("wise_oak_foliage_placer"), () -> new FoliagePlacerType(WiseOakFoliagePlacer.CODEC), Registry.f_122858_);
    public static final RegSupplier<TreeDecoratorType<WiseOakDecorator>> WISE_OAK_DECORATOR = RegHelper.register(MysticalOakTree.res("wise_oak_decorator"), () -> new TreeDecoratorType(WiseOakDecorator.CODEC), Registry.f_122860_);
    public static final RegSupplier<ConfiguredFeature<WiseOakFeature.Configuration, Feature<WiseOakFeature.Configuration>>> WISE_OAK = RegHelper.registerConfiguredFeature(MysticalOakTree.res("wise_oak"), WISE_OAK_FEATURE, () -> new WiseOakFeature.Configuration(ModFeatures.makeTree(false, false), ModFeatures.makeTree(true, false), ModFeatures.makeTree(true, true), (Holder<PlacedFeature>)PlacementUtils.m_206502_((Feature)Feature.f_65763_, (FeatureConfiguration)new RandomPatchConfiguration(50, 4, 2, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)Blocks.f_50112_.m_49966_(), 3).m_146271_((Object)Blocks.f_50357_.m_49966_(), 1).m_146271_((Object)Blocks.f_50072_.m_49966_(), 16).m_146271_((Object)Blocks.f_50073_.m_49966_(), 19))))), (PlacementModifier[])new PlacementModifier[0])));
    public static final RegSupplier<PlacedFeature> PLACED_WISE_OAK = RegHelper.registerPlacedFeature(MysticalOakTree.res("wise_oak"), WISE_OAK, () -> ModFeatures.treePlacementBase().build());

    public static void init() {
    }

    @NotNull
    private static Holder<PlacedFeature> makeTree(boolean hasVines, boolean hasRoots) {
        int h = hasRoots ? 1 : 0;
        TreeConfiguration.TreeConfigurationBuilder builder = new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_49999_), (TrunkPlacer)new WiseOakTrunkPlacer(7, 1 + h, 0 + h), (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50050_), (FoliagePlacer)new WiseOakFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)1), 4), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0, OptionalInt.of(4)));
        if (hasVines) {
            builder.m_68244_();
            builder.m_68249_(List.of(WiseOakDecorator.INSTANCE, new LeaveVineDecorator()));
        } else {
            builder.m_68249_(List.of(WiseOakDecorator.INSTANCE));
        }
        if (!hasRoots) {
            builder.m_161260_((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_152549_)).m_161262_();
        }
        return PlacementUtils.m_206502_((Feature)Feature.f_65760_, (FeatureConfiguration)builder.m_68251_(), (PlacementModifier[])new PlacementModifier[0]);
    }

    private static ImmutableList.Builder<PlacementModifier> treePlacementBase() {
        return ImmutableList.builder().add((Object)RarityFilter.m_191900_((int)200)).add((Object)InSquarePlacement.m_191715_()).add((Object)VegetationPlacements.f_195420_).add((Object)PlacementUtils.f_195355_).add((Object)BiomeFilter.m_191561_()).add((Object)BlockPredicateFilter.m_191576_((BlockPredicate)BlockPredicate.m_190399_((BlockState)Blocks.f_50746_.m_49966_(), (Vec3i)BlockPos.f_121853_)));
    }
}

