/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.mysticaloaktree.block;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.mehvahdjukaar.mysticaloaktree.MysticalOakTree;
import net.mehvahdjukaar.mysticaloaktree.block.Relationship;
import net.mehvahdjukaar.mysticaloaktree.block.WiseOakBlock;
import net.mehvahdjukaar.mysticaloaktree.client.TreeLoreManager;
import net.mehvahdjukaar.mysticaloaktree.client.dialogues.DialogueInstance;
import net.mehvahdjukaar.mysticaloaktree.client.dialogues.ITreeDialogue;
import net.mehvahdjukaar.mysticaloaktree.client.dialogues.TreeDialogueTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class WiseOakTile
extends BlockEntity {
    public static final int BLOW_DURATION = 34;
    public static final int FOLLOW_TIME = 60;
    public static final int DIALOGUES_TO_SLEEP = 6;
    public static final int BLINK_TIME = 5;
    private static final double BLOW_DIST = 11.0;
    private static final double THICC_CHANCE = 0.03;
    private final Map<UUID, Relationship> playerRelationship = new HashMap<UUID, Relationship>();
    private Player playerTarget;
    private int blowCounter;
    private int followCounter;
    private int dialoguesUntilSlept = 0;
    @Nullable
    private DialogueInstance currentDialogue = null;

    public WiseOakTile(BlockPos blockPos, BlockState blockState) {
        super(MysticalOakTree.TILE.get(), blockPos, blockState);
    }

    @NotNull
    private Relationship getRelationship(Player player) {
        return this.playerRelationship.computeIfAbsent(player.m_142081_(), u -> new Relationship(0));
    }

    public static void tick(Level level, BlockPos pos, BlockState state, WiseOakTile tile) {
        if (tile.blowCounter > 0) {
            --tile.blowCounter;
        }
        if (((WiseOakBlock.State)((Object)state.m_61143_(WiseOakBlock.STATE))).isBlowing()) {
            if (tile.blowCounter <= 0) {
                tile.stopBlowing(level, pos, state, tile);
            }
            if (tile.playerTarget != null && WiseOakTile.isInLineOfSight((Direction)state.m_61143_((Property)WiseOakBlock.f_54117_), pos, level, (Entity)tile.playerTarget)) {
                if (level.f_46443_) {
                    tile.blowParticles(state, level, pos);
                }
                tile.blowPlayer(state, level, pos);
            }
        }
        if (level.f_46443_) {
            if (tile.currentDialogue != null && !tile.currentDialogue.tick(pos)) {
                tile.currentDialogue = null;
            }
        } else {
            if (tile.followCounter > 0) {
                if (tile.playerTarget != null) {
                    WiseOakTile.rotateTowardPlayer(state, level, pos, tile.playerTarget);
                }
                --tile.followCounter;
                if (tile.followCounter == 0) {
                    tile.playerTarget = null;
                }
            }
            if (tile.blowCounter == 0 && level.m_46467_() % 23L == 0L && level.f_46441_.nextInt(21) == 0) {
                if (tile.dialoguesUntilSlept > 6 && state.m_61143_(WiseOakBlock.STATE) == WiseOakBlock.State.NONE) {
                    tile.goToSleep(level, pos, state);
                } else {
                    tile.randomTick(state, (ServerLevel)level, pos, level.f_46441_);
                }
            }
        }
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        boolean isDay;
        WiseOakBlock.State s = (WiseOakBlock.State)((Object)state.m_61143_(WiseOakBlock.STATE));
        if (s == WiseOakBlock.State.ANGRY && random.nextInt(3) == 0) {
            level.m_46597_(pos, (BlockState)state.m_61124_(WiseOakBlock.STATE, (Comparable)((Object)WiseOakBlock.State.NONE)));
            return;
        }
        boolean bl = isDay = !level.m_46462_();
        if (s.canSleep() && isDay) {
            this.goToSleep((Level)level, pos, state);
            return;
        }
        if (s == WiseOakBlock.State.SLEEPING && !isDay) {
            this.wakeUp((Level)level, pos, state);
            return;
        }
        if (s.canBlink() && random.nextFloat() < 1.0f) {
            level.m_186460_(pos, state.m_60734_(), 5);
            level.m_7731_(pos, (BlockState)state.m_61124_(WiseOakBlock.STATE, (Comparable)((Object)WiseOakBlock.State.getBlinking(s))), 3);
        }
    }

    private void goToSleep(Level level, BlockPos pos, BlockState state) {
        this.playerTarget = null;
        this.followCounter = 0;
        this.blowCounter = 0;
        level.m_46597_(pos, (BlockState)state.m_61124_(WiseOakBlock.STATE, (Comparable)((Object)WiseOakBlock.State.SLEEPING)));
    }

    private void wakeUp(Level level, BlockPos pos, BlockState state) {
        this.dialoguesUntilSlept = 0;
        level.m_46597_(pos, (BlockState)state.m_61124_(WiseOakBlock.STATE, (Comparable)((Object)WiseOakBlock.State.NONE)));
    }

    public InteractionResult onInteract(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand) {
        boolean wokenUp;
        WiseOakBlock.State treeState = (WiseOakBlock.State)((Object)state.m_61143_(WiseOakBlock.STATE));
        if (treeState.isAngry()) {
            return InteractionResult.PASS;
        }
        Relationship r = this.getRelationship(player);
        boolean bl = wokenUp = treeState == WiseOakBlock.State.SLEEPING;
        if (wokenUp || r.checkTalkCooldown(level)) {
            ++this.dialoguesUntilSlept;
            if (level.f_46443_) {
                DialogueInstance dialogue = this.getOrCreateDialogue(wokenUp ? TreeDialogueTypes.WOKEN_UP : TreeDialogueTypes.TALKED_TO, level.f_46441_, r);
                if (dialogue != null) {
                    dialogue.interact(pos);
                }
            } else {
                if (wokenUp || r.isInConfidence()) {
                    this.setTrackedTarget(player);
                }
                if (wokenUp || r.isFriendlyAt()) {
                    WiseOakTile.rotateTowardPlayer(state, level, pos, player);
                }
            }
            if (wokenUp) {
                this.wakeUp(level, pos, state);
                r.decrease();
                this.spawnAngryParticles(level, pos, state);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    @Nullable
    private DialogueInstance getOrCreateDialogue(ITreeDialogue.Type<?> source, Random Random2, Relationship r) {
        if (this.currentDialogue == null) {
            this.createRandomDialogue(source, Random2, r);
        }
        return this.currentDialogue;
    }

    private DialogueInstance createRandomDialogue(ITreeDialogue.Type<?> source, Random Random2, Relationship r) {
        ITreeDialogue dialogue = TreeLoreManager.getRandomDialogue(source, Random2, r.getTrust());
        if (dialogue != null) {
            this.currentDialogue = dialogue.createInstance();
            return this.currentDialogue;
        }
        return null;
    }

    public void onAttack(BlockState state, Level level, BlockPos pos, Player player) {
        DialogueInstance dialogue;
        Relationship r = this.getRelationship(player);
        this.spawnAngryParticles(level, pos, state);
        this.startBlowingAt(player, state, pos, level);
        if (level.f_46443_ && (dialogue = this.createRandomDialogue(TreeDialogueTypes.HURT, level.f_46441_, r)) != null) {
            dialogue.tick(pos);
        }
        r.decrease();
    }

    private void spawnAngryParticles(Level level, BlockPos pos, BlockState state) {
        level.m_7696_(pos, state.m_60734_(), 1, 0);
    }

    private void blowParticles(BlockState state, Level level, BlockPos pos) {
        if (this.playerTarget != null) {
            Direction dir = (Direction)state.m_61143_((Property)WiseOakBlock.f_54117_);
            Vec3 p = Vec3.m_82512_((Vec3i)pos);
            p = p.m_82549_(new Vec3((double)dir.m_122436_().m_123341_(), (double)dir.m_122436_().m_123342_(), (double)dir.m_122436_().m_123343_()).m_82490_(0.6));
            Vec3 speed = p.m_82546_(this.playerTarget.m_20182_().m_82520_(0.0, (double)(this.playerTarget.m_20192_() * 2.0f / 3.0f), 0.0));
            speed = speed.m_82541_();
            speed = speed.m_82490_((double)-0.4f);
            for (int j = 0; j < 2; ++j) {
                level.m_7106_((ParticleOptions)MysticalOakTree.WIND.get(), p.f_82479_ + (double)((level.f_46441_.nextFloat() - level.f_46441_.nextFloat()) * 0.05f), p.f_82480_ - 0.33 + (double)((level.f_46441_.nextFloat() - level.f_46441_.nextFloat()) * 0.05f), p.f_82481_, speed.f_82479_, speed.f_82480_, speed.f_82481_);
            }
        }
    }

    private void blowPlayer(BlockState state, Level level, BlockPos pos) {
        double max;
        double dist;
        if (this.playerTarget != null && (dist = pos.m_203193_((Position)this.playerTarget.m_20182_())) < (max = 121.0)) {
            double strength = 1.0 - dist / max;
            Vec3 direction = WiseOakTile.getViewVector(pos, (Entity)this.playerTarget);
            direction = direction.m_82490_((strength *= 1.0 - 0.25 * Mth.m_14008_((double)this.playerTarget.m_21133_(Attributes.f_22278_), (double)0.0, (double)1.0)) * 0.25);
            Vec3 vec3 = this.playerTarget.m_20184_();
            this.playerTarget.m_20334_(vec3.f_82479_ + direction.f_82479_, vec3.f_82480_ + (double)(this.playerTarget.m_20096_() ? 0.0f : 0.0f), vec3.f_82481_ + direction.f_82481_);
        }
    }

    private static Vec3 getViewVector(BlockPos pos, Entity entity) {
        Vec3 p = Vec3.m_82512_((Vec3i)pos);
        Vec3 speed = entity.m_20182_().m_82546_(p);
        speed = speed.m_82541_();
        return speed;
    }

    private void stopBlowing(Level level, BlockPos pos, BlockState state, WiseOakTile tile) {
        tile.playerTarget = null;
        tile.followCounter = 0;
        level.m_46597_(pos, (BlockState)state.m_61124_(WiseOakBlock.STATE, (Comparable)((Object)WiseOakBlock.State.ANGRY)));
    }

    private void startBlowingAt(Player player, BlockState state, BlockPos pos, Level level) {
        WiseOakTile.rotateTowardPlayer(state, level, pos, player);
        this.blowCounter = 34;
        level.m_46597_(pos, (BlockState)level.m_8055_(pos).m_61124_(WiseOakBlock.STATE, (Comparable)((Object)((double)level.f_46441_.nextFloat() < 0.03 ? WiseOakBlock.State.THICC : WiseOakBlock.State.BLOWING))));
        this.setTrackedTarget(player);
    }

    private void setTrackedTarget(Player player) {
        this.playerTarget = player;
        this.followCounter = 60;
    }

    public static void rotateTowardPlayer(BlockState state, Level level, BlockPos pos, Player player) {
        Vec3 v = player.m_20182_().m_82492_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        Direction d = Direction.m_122366_((double)v.f_82479_, (double)0.0, (double)v.f_82481_);
        if (d.m_122434_() != Direction.Axis.Y && state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) != d) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)d));
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ListTag list = new ListTag();
        for (Map.Entry<UUID, Relationship> v : this.playerRelationship.entrySet()) {
            CompoundTag comp = new CompoundTag();
            comp.m_128405_("trust", v.getValue().getTrust());
            comp.m_128362_("id", v.getKey());
            list.add((Object)comp);
        }
        if (!list.isEmpty()) {
            tag.m_128365_("relationship", (Tag)list);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.playerRelationship.clear();
        ListTag list = tag.m_128437_("relationship", 10);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag effectsCompound = list.m_128728_(i);
                UUID id = effectsCompound.m_128342_("id");
                Integer level = effectsCompound.m_128451_("trust");
                if (id == null) continue;
                this.playerRelationship.put(id, new Relationship(level));
            }
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    private static boolean isInLineOfSight(Direction dir, BlockPos pos, Level level, Entity target) {
        Vec3 startPos = Vec3.m_82512_((Vec3i)pos).m_82520_((double)dir.m_122436_().m_123341_() * 0.6, (double)dir.m_122436_().m_123342_() * 0.6, (double)dir.m_122436_().m_123343_() * 0.6);
        if (target.m_20238_(startPos) > 121.0) {
            return false;
        }
        return WiseOakTile.clip(level, startPos, target.m_146892_()).m_6662_() == HitResult.Type.MISS;
    }

    public static BlockHitResult clip(Level level, Vec3 startPos, Vec3 endPos) {
        ClipContext.Block blockGetter = ClipContext.Block.COLLIDER;
        ClipContext.Fluid fluidGetter = ClipContext.Fluid.NONE;
        CollisionContext collision = CollisionContext.m_82749_();
        return (BlockHitResult)BlockGetter.m_151361_((Vec3)startPos, (Vec3)endPos, null, (Null, pos) -> {
            BlockState blockstate = level.m_8055_(pos);
            FluidState fluidstate = level.m_6425_(pos);
            VoxelShape voxelShape = blockGetter.m_7544_(blockstate, (BlockGetter)level, pos, collision);
            BlockHitResult blockHitResult = level.m_45558_(startPos, endPos, pos, voxelShape, blockstate);
            VoxelShape fluidShape = fluidGetter.m_45731_(fluidstate) ? fluidstate.m_76183_((BlockGetter)level, pos) : Shapes.m_83040_();
            BlockHitResult fluidHirResult = fluidShape.m_83220_(startPos, endPos, pos);
            double d0 = blockHitResult == null ? Double.MAX_VALUE : startPos.m_82557_(blockHitResult.m_82450_());
            double d1 = fluidHirResult == null ? Double.MAX_VALUE : startPos.m_82557_(fluidHirResult.m_82450_());
            return d0 <= d1 ? blockHitResult : fluidHirResult;
        }, arg -> {
            Vec3 vec3 = startPos.m_82546_(endPos);
            return BlockHitResult.m_82426_((Vec3)endPos, (Direction)Direction.m_122366_((double)vec3.f_82479_, (double)vec3.f_82480_, (double)vec3.f_82481_), (BlockPos)new BlockPos(endPos));
        });
    }
}

