/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.mysticaloaktree.block;

import dev.architectury.injectables.annotations.PlatformOnly;
import java.util.List;
import java.util.Random;
import net.mehvahdjukaar.mysticaloaktree.MysticalOakTree;
import net.mehvahdjukaar.mysticaloaktree.block.WiseOakTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class WiseOakBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final EnumProperty<State> STATE = EnumProperty.m_61587_((String)"state", State.class);
    private static final List<BlockPos> KNOWLEDGE_PARTICLE_POS = BlockPos.m_121886_((int)-2, (int)-2, (int)-2, (int)2, (int)1, (int)2).filter(blockPos -> Math.abs(blockPos.m_123341_()) == 2 || Math.abs(blockPos.m_123343_()) == 2).map(BlockPos::m_7949_).toList();
    private static final List<BlockPos> DESTROY_PARTICLE_POS = BlockPos.m_121886_((int)-3, (int)-3, (int)-2, (int)3, (int)2, (int)3).filter(blockPos -> {
        double l = Vec3.m_82512_((Vec3i)blockPos).m_82553_();
        return l > 2.5 && l < 3.5;
    }).map(BlockPos::m_7949_).toList();

    public WiseOakBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_(STATE, (Comparable)((Object)State.NONE)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{STATE, f_54117_});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new WiseOakTile(pos, state);
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        super.m_7458_(state, level, pos, random);
        State s = (State)((Object)state.m_61143_(STATE));
        if (s.isBlinking()) {
            level.m_7731_(pos, (BlockState)state.m_61124_(STATE, (Comparable)((Object)State.getNonBlinking(s))), 3);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof WiseOakTile) {
            WiseOakTile tile = (WiseOakTile)blockEntity;
            return tile.onInteract(state, level, pos, player, hand);
        }
        return InteractionResult.PASS;
    }

    public void m_6256_(BlockState state, Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof WiseOakTile) {
            WiseOakTile tile = (WiseOakTile)blockEntity;
            tile.onAttack(state, level, pos, player);
        }
        super.m_6256_(state, level, pos, player);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return WiseOakBlock.getTicker(pBlockEntityType, MysticalOakTree.TILE.get(), WiseOakTile::tick);
    }

    @javax.annotation.Nullable
    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> getTicker(BlockEntityType<A> type, BlockEntityType<E> targetType, BlockEntityTicker<? super E> ticker) {
        return targetType == type ? ticker : null;
    }

    @Nullable
    public <T extends BlockEntity> GameEventListener m_142226_(Level level, T blockEntity) {
        return super.m_142226_(level, blockEntity);
    }

    public boolean m_8133_(BlockState state, Level level, BlockPos pos, int id, int param) {
        if (id == 1) {
            if (level.f_46443_) {
                for (Direction d : Direction.Plane.HORIZONTAL) {
                    ParticleUtils.m_144957_((Level)level, (BlockPos)pos, (Direction)d, (ParticleOptions)ParticleTypes.f_123792_);
                }
            }
            return true;
        }
        return super.m_8133_(state, level, pos, id, param);
    }

    public void m_7100_(BlockState state, Level level, BlockPos pos, Random random) {
        super.m_7100_(state, level, pos, random);
        if (state.m_61143_(STATE) == State.SLEEPING && random.nextInt(14) == 0) {
            BlockPos targetPos = KNOWLEDGE_PARTICLE_POS.get(level.f_46441_.nextInt(KNOWLEDGE_PARTICLE_POS.size()));
            WiseOakBlock.spawnEnchantParticle(level, pos.m_7494_(), random, targetPos);
        }
    }

    private static void spawnEnchantParticle(Level level, BlockPos pos, Random random, BlockPos targetPos) {
        level.m_7106_((ParticleOptions)ParticleTypes.f_123809_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (double)((float)targetPos.m_123341_() + random.nextFloat()) - 0.5, (double)((float)targetPos.m_123342_() + random.nextFloat()) - 0.5, (double)((float)targetPos.m_123343_() + random.nextFloat()) - 0.5);
    }

    protected void m_142387_(Level level, Player player, BlockPos pos, BlockState state) {
        super.m_142387_(level, player, pos, state);
        if (!EnchantmentHelper.m_44831_((ItemStack)player.m_21120_(player.m_7655_())).containsKey(Enchantments.f_44985_)) {
            for (int i = 0; i < 30; ++i) {
                BlockPos targetPos = DESTROY_PARTICLE_POS.get(level.f_46441_.nextInt(DESTROY_PARTICLE_POS.size()));
                WiseOakBlock.spawnEnchantParticle(level, pos.m_141952_((Vec3i)targetPos), level.f_46441_, targetPos.m_142393_(-1));
            }
        }
    }

    @PlatformOnly(value={"forge"})
    public float getEnchantPowerBonus(BlockState state, LevelReader level, BlockPos pos) {
        return 15.0f;
    }

    public static enum State implements StringRepresentable
    {
        NONE("none"),
        BLINKING("blinking"),
        SLEEPING("sleeping"),
        ANGRY("angry"),
        ANGRY_BLINKING("angry_blinking"),
        BLOWING("blowing"),
        THICC("thicc");

        private final String name;

        private State(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public boolean canBlink() {
            return this == NONE || this == ANGRY;
        }

        public boolean isBlinking() {
            return this == BLINKING || this == ANGRY_BLINKING;
        }

        public static State getBlinking(State s) {
            if (s == ANGRY || s == BLOWING || s == THICC) {
                return ANGRY_BLINKING;
            }
            return BLINKING;
        }

        public static State getNonBlinking(State s) {
            if (s == ANGRY_BLINKING) {
                return ANGRY;
            }
            return NONE;
        }

        public boolean canSleep() {
            return this == NONE || this == BLINKING;
        }

        public boolean isAngry() {
            return this == ANGRY || this == ANGRY_BLINKING;
        }

        public boolean isBlowing() {
            return this == BLOWING || this == THICC;
        }
    }
}

