/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.mixin.storage.upgrade;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.List;
import java.util.Objects;
import net.flytre.flytre_lib.api.base.util.InventoryUtils;
import net.flytre.flytre_lib.api.storage.upgrade.UpgradeHandler;
import net.flytre.flytre_lib.api.storage.upgrade.UpgradeInventory;
import net.flytre.flytre_lib.api.storage.upgrade.UpgradeSlot;
import net.flytre.flytre_lib.impl.storage.upgrade.gui.UpgradeHandlerListener;
import net.flytre.flytre_lib.impl.storage.upgrade.gui.UpgradeHandlerSyncHandler;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractContainerMenu.class})
abstract class ScreenHandlerMixin
implements UpgradeHandler {
    @Unique
    public NonNullList<UpgradeSlot> upgradeSlots = NonNullList.m_122779_();
    @Shadow
    @Final
    public NonNullList<Slot> f_38839_;
    @Unique
    private NonNullList<ItemStack> trackedUpgradeStacks = NonNullList.m_122779_();
    @Unique
    private NonNullList<ItemStack> previousTrackedUpgradeStacks = NonNullList.m_122779_();
    @Unique
    @Nullable
    private UpgradeHandlerSyncHandler upgradeSyncHandler;
    @Shadow
    @Final
    private List<ContainerListener> f_38848_;
    @Shadow
    @Final
    @Nullable
    private MenuType<?> f_38843_;
    @Shadow
    private boolean f_150398_;

    ScreenHandlerMixin() {
    }

    @Shadow
    public abstract void m_150429_();

    @Shadow
    public abstract ItemStack m_142621_();

    @Shadow
    public abstract void m_142503_(ItemStack var1);

    @Shadow
    public abstract void m_38946_();

    @Shadow
    protected abstract boolean m_38903_(ItemStack var1, int var2, int var3, boolean var4);

    @Shadow
    protected abstract Slot m_38897_(Slot var1);

    @Inject(method={"<init>*"}, at={@At(value="TAIL")})
    public void flytre_lib$init(MenuType<?> type, int syncId, CallbackInfo ci) {
        this.upgradeSlots = NonNullList.m_122779_();
        this.trackedUpgradeStacks = NonNullList.m_122779_();
        this.previousTrackedUpgradeStacks = NonNullList.m_122779_();
    }

    @Override
    public UpgradeSlot addSlot(UpgradeSlot slot) {
        slot.f_40219_ = this.upgradeSlots.size();
        this.upgradeSlots.add((Object)slot);
        this.trackedUpgradeStacks.add((Object)ItemStack.f_41583_);
        this.previousTrackedUpgradeStacks.add((Object)ItemStack.f_41583_);
        return slot;
    }

    @Override
    public NonNullList<ItemStack> getUpgradeStacks() {
        NonNullList defaultedList = NonNullList.m_122779_();
        for (UpgradeSlot upgradeSlot : this.upgradeSlots) {
            defaultedList.add((Object)upgradeSlot.m_7993_());
        }
        return defaultedList;
    }

    @Override
    public void updateSyncHandler(UpgradeHandlerSyncHandler handler) {
        this.upgradeSyncHandler = handler;
        this.m_150429_();
    }

    @Inject(method={"syncState"}, at={@At(value="HEAD")})
    public void flytre_lib$syncUpgradeState(CallbackInfo ci) {
        int l = this.upgradeSlots.size();
        for (int k = 0; k < l; ++k) {
            this.previousTrackedUpgradeStacks.set(k, (Object)((UpgradeSlot)((Object)this.upgradeSlots.get(k))).m_7993_().m_41777_());
        }
        if (this.upgradeSyncHandler != null) {
            this.upgradeSyncHandler.updateUpgradeState(this, this.previousTrackedUpgradeStacks);
        }
    }

    @Inject(method={"sendContentUpdates"}, at={@At(value="RETURN")})
    public void flytre_lib$sendUpgradeContentUpdates(CallbackInfo ci) {
        for (int j = 0; j < this.upgradeSlots.size(); ++j) {
            ItemStack itemStack = ((UpgradeSlot)((Object)this.upgradeSlots.get(j))).m_7993_();
            Objects.requireNonNull(itemStack);
            Supplier supplier = Suppliers.memoize(() -> ((ItemStack)itemStack).m_41777_());
            this.updateUpgradeTrackedSlot(j, itemStack, (java.util.function.Supplier<ItemStack>)supplier);
            this.checkUpgradeSlotUpdates(j, itemStack, (java.util.function.Supplier<ItemStack>)supplier);
        }
    }

    private void updateUpgradeTrackedSlot(int slot, ItemStack stack, java.util.function.Supplier<ItemStack> copyMaker) {
        ItemStack itemStack = (ItemStack)this.trackedUpgradeStacks.get(slot);
        if (!ItemStack.m_41728_((ItemStack)itemStack, (ItemStack)stack)) {
            ItemStack itemStack2 = copyMaker.get();
            this.trackedUpgradeStacks.set(slot, (Object)itemStack2);
            for (ContainerListener listener : this.f_38848_) {
                if (!(listener instanceof UpgradeHandlerListener)) continue;
                ((UpgradeHandlerListener)listener).onUpgradeSlotUpdate(this, slot, itemStack2);
            }
        }
    }

    private void checkUpgradeSlotUpdates(int slot, ItemStack stack, java.util.function.Supplier<ItemStack> copyMaker) {
        ItemStack itemStack;
        if (!this.f_150398_ && !ItemStack.m_41728_((ItemStack)(itemStack = (ItemStack)this.previousTrackedUpgradeStacks.get(slot)), (ItemStack)stack)) {
            ItemStack fluidStack2 = copyMaker.get();
            this.previousTrackedUpgradeStacks.set(slot, (Object)fluidStack2);
            if (this.upgradeSyncHandler != null) {
                this.upgradeSyncHandler.updateSlot(this, slot, fluidStack2);
            }
        }
    }

    @Override
    public void setPreviousTrackedUpgradeSlot(int slot, ItemStack stack) {
        this.previousTrackedUpgradeStacks.set(slot, (Object)stack);
    }

    @Override
    public UpgradeSlot getUpgradeSlot(int index) {
        return (UpgradeSlot)((Object)this.upgradeSlots.get(index));
    }

    @Override
    public void setUpgradeStackInSlot(int slot, ItemStack stack) {
        this.getUpgradeSlot(slot).m_5852_(stack);
    }

    @Override
    public void updateUpgradeSlotStacks(List<ItemStack> stacks) {
        for (int i = 0; i < stacks.size(); ++i) {
            this.getUpgradeSlot(i).m_5852_(stacks.get(i));
        }
    }

    @Override
    public void onUpgradeSlotClick(int slotId, int clickData, ClickType actionType, Player playerEntity) {
        try {
            this.upgradeSlotClickHelper(slotId, clickData, actionType, playerEntity);
        }
        catch (Exception var8) {
            CrashReport crashReport = CrashReport.m_127521_((Throwable)var8, (String)"Mechanix Upgrade Container click");
            CrashReportCategory crashReportSection = crashReport.m_127514_("Click info");
            crashReportSection.m_128165_("Menu Type", () -> this.f_38843_ != null ? Objects.requireNonNull(Registry.f_122863_.m_7981_(this.f_38843_)).toString() : "<no type>");
            crashReportSection.m_128165_("Menu Class", () -> this.getClass().getCanonicalName());
            crashReportSection.m_128159_("Upgrade Slot Count", (Object)this.upgradeSlots.size());
            crashReportSection.m_128159_("Slot", (Object)slotId);
            crashReportSection.m_128159_("Button", (Object)clickData);
            crashReportSection.m_128159_("Type", (Object)actionType);
            throw new ReportedException(crashReport);
        }
    }

    private void upgradeSlotClickHelper(int slotId, int clickData, ClickType slotActionType, Player playerEntity) {
        Inventory playerInventory = playerEntity.m_150109_();
        if (!(slotActionType != ClickType.PICKUP && slotActionType != ClickType.QUICK_MOVE || clickData != 0 && clickData != 1)) {
            if (slotId == -999) {
                if (!this.m_142621_().m_41619_()) {
                    if (clickData == 0) {
                        playerEntity.m_36176_(this.m_142621_(), true);
                        this.m_142503_(ItemStack.f_41583_);
                    }
                    if (clickData == 1) {
                        playerEntity.m_36176_(this.m_142621_().m_41620_(1), true);
                    }
                }
            } else if (slotActionType == ClickType.QUICK_MOVE) {
                if (slotId < 0) {
                    return;
                }
                UpgradeSlot slot = (UpgradeSlot)((Object)this.upgradeSlots.get(slotId));
                if (!slot.m_8010_(playerEntity)) {
                    return;
                }
                ItemStack stack = this.transferUpgradeSlot(playerEntity, slotId);
                while (!stack.m_41619_() && ItemStack.m_41746_((ItemStack)slot.m_7993_(), (ItemStack)stack)) {
                    stack = this.transferUpgradeSlot(playerEntity, slotId);
                }
            } else {
                if (slotId < 0) {
                    return;
                }
                UpgradeSlot slot = (UpgradeSlot)((Object)this.upgradeSlots.get(slotId));
                ItemStack stack = slot.m_7993_();
                ItemStack stack2 = this.m_142621_();
                if (stack.m_41619_()) {
                    int q;
                    int n = q = clickData == 0 ? stack2.m_41613_() : 1;
                    if (!stack2.m_41619_() && slot.canInsert(stack2, q)) {
                        if (q > slot.m_5866_(stack2)) {
                            q = slot.m_5866_(stack2);
                        }
                        slot.m_5852_(stack2.m_41620_(q));
                    }
                } else if (slot.m_8010_(playerEntity)) {
                    int q;
                    if (stack2.m_41619_()) {
                        if (stack.m_41619_()) {
                            slot.m_5852_(ItemStack.f_41583_);
                            this.m_142503_(ItemStack.f_41583_);
                        } else {
                            int q2 = clickData == 0 ? stack.m_41613_() : (stack.m_41613_() + 1) / 2;
                            this.m_142503_(slot.m_6201_(q2));
                            if (stack.m_41619_()) {
                                slot.m_5852_(ItemStack.f_41583_);
                            }
                            slot.m_142406_(playerEntity, this.m_142621_());
                        }
                    } else if (slot.canInsert(stack2, clickData == 0 ? stack2.m_41613_() : 1)) {
                        if (InventoryUtils.canMergeItems(stack, stack2)) {
                            int q3;
                            int n = q3 = clickData == 0 ? stack2.m_41613_() : 1;
                            if (q3 > slot.m_5866_(stack2) - stack.m_41613_()) {
                                q3 = slot.m_5866_(stack2) - stack.m_41613_();
                            }
                            if (q3 > stack2.m_41741_() - stack.m_41613_()) {
                                q3 = stack2.m_41741_() - stack.m_41613_();
                            }
                            stack2.m_41774_(q3);
                            stack.m_41769_(q3);
                        } else if (stack2.m_41613_() <= slot.m_5866_(stack2)) {
                            slot.m_5852_(stack2);
                            this.m_142503_(stack);
                        }
                    } else if (stack2.m_41741_() > 1 && InventoryUtils.canMergeItems(stack, stack2) && !stack.m_41619_() && (q = stack.m_41613_()) + stack2.m_41613_() <= stack2.m_41741_()) {
                        stack2.m_41769_(q);
                        stack = slot.m_6201_(q);
                        if (stack.m_41619_()) {
                            slot.m_5852_(ItemStack.f_41583_);
                        }
                        slot.m_142406_(playerEntity, this.m_142621_());
                    }
                }
                slot.m_6654_();
            }
        } else if (slotActionType == ClickType.SWAP) {
            UpgradeSlot slot = (UpgradeSlot)((Object)this.upgradeSlots.get(slotId));
            ItemStack stack = playerInventory.m_8020_(clickData);
            ItemStack stack2 = slot.m_7993_();
            if (!stack.m_41619_() || !stack2.m_41619_()) {
                if (stack.m_41619_()) {
                    if (slot.m_8010_(playerEntity)) {
                        playerInventory.m_6836_(clickData, stack2);
                        slot.m_5852_(ItemStack.f_41583_);
                        slot.m_142406_(playerEntity, stack2);
                    }
                } else if (stack2.m_41619_()) {
                    if (slot.m_5857_(stack)) {
                        int q = slot.m_5866_(stack);
                        if (stack.m_41613_() > q) {
                            slot.m_5852_(stack.m_41620_(q));
                        } else {
                            slot.m_5852_(stack);
                            playerInventory.m_6836_(clickData, ItemStack.f_41583_);
                        }
                    }
                } else if (slot.m_8010_(playerEntity) && slot.m_5857_(stack)) {
                    int q = slot.m_5866_(stack);
                    if (stack.m_41613_() > q) {
                        slot.m_5852_(stack.m_41620_(q));
                        slot.m_142406_(playerEntity, stack2);
                        if (!playerInventory.m_36054_(stack2)) {
                            playerEntity.m_36176_(stack2, true);
                        }
                    } else {
                        slot.m_5852_(stack);
                        playerInventory.m_6836_(clickData, stack2);
                        slot.m_142406_(playerEntity, stack2);
                    }
                }
            }
        } else if (slotActionType == ClickType.CLONE && playerEntity.m_150110_().f_35937_ && this.m_142621_().m_41619_() && slotId >= 0) {
            UpgradeSlot slot = (UpgradeSlot)((Object)this.upgradeSlots.get(slotId));
            if (slot.m_6657_()) {
                ItemStack stack = slot.m_7993_().m_41777_();
                stack.m_41764_(stack.m_41741_());
                this.m_142503_(stack);
            }
        } else if (slotActionType == ClickType.THROW && this.m_142621_().m_41619_() && slotId >= 0) {
            UpgradeSlot slot = (UpgradeSlot)((Object)this.upgradeSlots.get(slotId));
            if (slot.m_6657_() && slot.m_8010_(playerEntity)) {
                ItemStack stack = slot.m_6201_(clickData == 0 ? 1 : slot.m_7993_().m_41613_());
                slot.m_142406_(playerEntity, stack);
                playerEntity.m_36176_(stack, true);
            }
        } else if (slotActionType == ClickType.PICKUP_ALL && slotId >= 0) {
            UpgradeSlot slot = (UpgradeSlot)((Object)this.upgradeSlots.get(slotId));
            ItemStack stack = this.m_142621_();
            if (!(stack.m_41619_() || slot.m_6657_() && slot.m_8010_(playerEntity))) {
                int l = clickData == 0 ? 0 : this.upgradeSlots.size() - 1;
                int q = clickData == 0 ? 1 : -1;
                for (int w = 0; w < 2; ++w) {
                    for (int x = l; x >= 0 && x < this.upgradeSlots.size() && stack.m_41613_() < stack.m_41741_(); x += q) {
                        UpgradeSlot currentSlot = (UpgradeSlot)((Object)this.upgradeSlots.get(x));
                        if (!currentSlot.m_6657_() || !UpgradeHandler.canInsertItemIntoSlot(currentSlot, stack, true) || !currentSlot.m_8010_(playerEntity)) continue;
                        ItemStack currentStack = currentSlot.m_7993_();
                        if (w == 0 && currentStack.m_41613_() == currentStack.m_41741_()) continue;
                        int n = Math.min(stack.m_41741_() - stack.m_41613_(), currentStack.m_41613_());
                        ItemStack taken = currentSlot.m_6201_(n);
                        stack.m_41769_(n);
                        if (taken.m_41619_()) {
                            currentSlot.m_5852_(ItemStack.f_41583_);
                        }
                        currentSlot.m_142406_(playerEntity, taken);
                    }
                }
            }
            this.m_38946_();
        }
    }

    @Override
    public void addStandardUpgradeSlots(UpgradeInventory entity) {
        this.addSlot(new UpgradeSlot(entity, 0, 191, 84));
        this.addSlot(new UpgradeSlot(entity, 1, 211, 84));
        this.addSlot(new UpgradeSlot(entity, 2, 191, 104));
        this.addSlot(new UpgradeSlot(entity, 3, 211, 104));
    }

    @Override
    public NonNullList<UpgradeSlot> getUpgradeSlots() {
        return this.upgradeSlots;
    }

    @Override
    public ItemStack transferUpgradeSlot(Player player, int index) {
        UpgradeSlot slot = (UpgradeSlot)((Object)this.upgradeSlots.get(index));
        ItemStack stack = ItemStack.f_41583_;
        if (slot.m_6657_()) {
            int maxIndex;
            int minIndex;
            stack = slot.m_7993_();
            for (minIndex = 0; minIndex < this.f_38839_.size() && !((Slot)this.f_38839_.get((int)minIndex)).f_40218_.equals(player.m_150109_()); ++minIndex) {
            }
            for (maxIndex = minIndex; maxIndex < this.f_38839_.size() && ((Slot)this.f_38839_.get((int)maxIndex)).f_40218_.equals(player.m_150109_()); ++maxIndex) {
            }
            if (!this.m_38903_(stack, minIndex, maxIndex, false)) {
                return ItemStack.f_41583_;
            }
        }
        return stack;
    }

    @Override
    public void addInventorySlots(Inventory playerInventory) {
        int o;
        for (o = 0; o < 3; ++o) {
            for (int n = 0; n < 9; ++n) {
                this.m_38897_(new Slot((Container)playerInventory, n + o * 9 + 9, 8 + n * 18, 84 + o * 18));
            }
        }
        for (o = 0; o < 9; ++o) {
            this.m_38897_(new Slot((Container)playerInventory, o, 8 + o * 18, 142));
        }
    }

    @Override
    public AbstractContainerMenu get() {
        return (AbstractContainerMenu)this;
    }
}

