/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.mixin.storage.upgrade;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Map;
import net.flytre.flytre_lib.api.storage.upgrade.UpgradeHandler;
import net.flytre.flytre_lib.api.storage.upgrade.UpgradeSlot;
import net.flytre.flytre_lib.impl.storage.upgrade.network.UpgradeClickSlotC2SPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractContainerScreen.class})
abstract class HandledScreenMixin<T extends AbstractContainerMenu>
extends Screen {
    @Unique
    private static final ResourceLocation UPGRADE = new ResourceLocation("flytre_lib:textures/gui/container/upgrade.png");
    @Shadow
    @Final
    protected T f_97732_;
    @Shadow
    protected int f_97726_;
    @Shadow
    protected int f_97735_;
    @Shadow
    protected int f_97736_;
    @Shadow
    @Nullable
    protected Slot f_97734_;

    protected HandledScreenMixin(Component title) {
        super(title);
    }

    @Shadow
    protected abstract boolean m_97774_(Slot var1, double var2, double var4);

    @Shadow
    protected abstract void m_97799_(PoseStack var1, Slot var2);

    @Inject(method={"getSlotAt"}, at={@At(value="TAIL")}, cancellable=true)
    public void flytre_lib$getUpgradeSlotAt(double xPosition, double yPosition, CallbackInfoReturnable<Slot> cir) {
        if (this.f_97732_ instanceof UpgradeHandler) {
            UpgradeHandler handler = (UpgradeHandler)this.f_97732_;
            for (int i = 0; i < handler.getUpgradeSlots().size(); ++i) {
                Slot slot = (Slot)handler.getUpgradeSlots().get(i);
                if (!this.m_97774_(slot, xPosition, yPosition) || !slot.m_6659_()) continue;
                cir.setReturnValue((Object)slot);
            }
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    public void flytre_lib$renderQuadUpgradePanel(PoseStack matrices, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (this.f_97732_ instanceof UpgradeHandler && ((UpgradeHandler)this.f_97732_).getUpgradeSlots().size() == 4) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)UPGRADE);
            this.m_93228_(matrices, this.f_97735_ + this.f_97726_, this.f_97736_ + 70, 0, 0, 65, 65);
        }
    }

    @Inject(method={"isClickOutsideBounds"}, at={@At(value="HEAD")}, cancellable=true)
    public void flytre_lib$inBounds(double mouseX, double mouseY, int left, int top, int button, CallbackInfoReturnable<Boolean> cir) {
        if (this.f_97732_ instanceof UpgradeHandler && ((UpgradeHandler)this.f_97732_).getUpgradeSlots().size() == 4 && mouseX >= (double)left && mouseY >= (double)top + 70.0 && mouseX < (double)(left + this.f_97726_ + 65) && mouseY <= (double)(top + 135)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/ingame/HandledScreen;drawForeground(Lnet/minecraft/client/util/math/MatrixStack;II)V", shift=At.Shift.BEFORE)})
    public void flytre_lib$upgradeHandledScreenRender(PoseStack matrices, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (this.f_97732_ instanceof UpgradeHandler) {
            UpgradeHandler handler = (UpgradeHandler)this.f_97732_;
            for (int m = 0; m < handler.getUpgradeSlots().size(); ++m) {
                Slot slot = (Slot)handler.getUpgradeSlots().get(m);
                if (slot.m_6659_()) {
                    this.m_97799_(matrices, slot);
                }
                if (!this.m_97774_(slot, mouseX, mouseY) || !slot.m_6659_()) continue;
                this.f_97734_ = slot;
                RenderSystem.m_69465_();
                int n = slot.f_40220_;
                int r = slot.f_40221_;
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                this.m_93179_(matrices, n, r, n + 16, r + 16, -2130706433, -2130706433);
                RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                RenderSystem.m_69482_();
            }
        }
    }

    @Inject(method={"onMouseClick(Lnet/minecraft/screen/slot/Slot;IILnet/minecraft/screen/slot/SlotActionType;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void flytre_lib$onUpgradeSlotClicked(Slot slot, int slotId, int button, ClickType actionType, CallbackInfo ci) {
        if (this.f_97732_ instanceof UpgradeHandler && slot != null && ((UpgradeHandler)this.f_97732_).getUpgradeSlots().stream().anyMatch(i -> i == slot)) {
            slotId = slot.f_40219_;
            assert (this.f_96541_ != null);
            this.flytre_lib$clickSlot(((AbstractContainerMenu)this.f_97732_).f_38840_, slotId, button, actionType, this.f_96541_.f_91074_);
            ci.cancel();
        }
    }

    @Unique
    private void flytre_lib$clickSlot(int syncId, int slotId, int button, ClickType actionType, LocalPlayer player) {
        UpgradeHandler handler = (UpgradeHandler)this.f_97732_;
        ArrayList list = Lists.newArrayListWithCapacity((int)handler.getUpgradeSlots().size());
        for (UpgradeSlot slot : handler.getUpgradeSlots()) {
            list.add(slot.m_7993_().m_41777_());
        }
        handler.onUpgradeSlotClick(slotId, button, actionType, (Player)player);
        Int2ObjectOpenHashMap modifiedStacks = new Int2ObjectOpenHashMap();
        for (int j = 0; j < handler.getUpgradeSlots().size(); ++j) {
            ItemStack modifiedStack;
            ItemStack originalStack = (ItemStack)list.get(j);
            if (ItemStack.m_41728_((ItemStack)originalStack, (ItemStack)(modifiedStack = ((UpgradeSlot)((Object)handler.getUpgradeSlots().get(j))).m_7993_()))) continue;
            modifiedStacks.put(j, modifiedStack.m_41777_());
        }
        ClientPacketListener networkHandler = Minecraft.m_91087_().m_91403_();
        assert (networkHandler != null);
        networkHandler.m_104955_((Packet)new UpgradeClickSlotC2SPacket(syncId, slotId, button, actionType, (Map<Integer, ItemStack>)modifiedStacks, this.f_97732_.m_142621_().m_41777_()));
    }
}

