/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.mixin.base;

import io.netty.buffer.Unpooled;
import net.flytre.flytre_lib.impl.base.PacketUtilsImpl;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={Connection.class})
class ClientConnectionMixin {
    ClientConnectionMixin() {
    }

    @ModifyVariable(method={"handlePacket"}, at=@At(value="HEAD"), argsOnly=true)
    private static <T extends PacketListener> Packet<T> flytre_lib$repackPacket(Packet<T> packet) {
        if (packet instanceof ServerboundCustomPayloadPacket && PacketUtilsImpl.REGISTERED_IDS.containsKey(((ServerboundCustomPayloadPacket)packet).m_179589_())) {
            FriendlyByteBuf buf = ((ServerboundCustomPayloadPacket)packet).m_179590_();
            ResourceLocation channel = ((ServerboundCustomPayloadPacket)packet).m_179589_();
            int index = PacketUtilsImpl.REGISTERED_IDS.get(channel).index();
            PacketUtilsImpl.Triad<? extends Packet<ServerGamePacketListener>> triad = PacketUtilsImpl.PLAY_C2S_PACKET.get(index);
            return triad.creator().apply(buf);
        }
        if (packet instanceof ClientboundCustomPayloadPacket && PacketUtilsImpl.REGISTERED_IDS.containsKey(((ClientboundCustomPayloadPacket)packet).m_132042_())) {
            FriendlyByteBuf buf = ((ClientboundCustomPayloadPacket)packet).m_132045_();
            ResourceLocation channel = ((ClientboundCustomPayloadPacket)packet).m_132042_();
            int index = PacketUtilsImpl.REGISTERED_IDS.get(channel).index();
            PacketUtilsImpl.Triad<? extends Packet<ClientGamePacketListener>> triad = PacketUtilsImpl.PLAY_S2C_PACKET.get(index);
            return triad.creator().apply(buf);
        }
        return packet;
    }

    @ModifyVariable(method={"send(Lnet/minecraft/network/Packet;Lio/netty/util/concurrent/GenericFutureListener;)V"}, at=@At(value="HEAD"), argsOnly=true)
    public Packet<?> flytre_lib$modifySentPacket(Packet<?> packet) {
        if (PacketUtilsImpl.REGISTERED_TYPES.containsKey(packet.getClass())) {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            packet.m_5779_(buf);
            PacketUtilsImpl.PacketData data = PacketUtilsImpl.REGISTERED_TYPES.get(packet.getClass());
            if (data.clientbound()) {
                ResourceLocation id = PacketUtilsImpl.PLAY_S2C_PACKET.get(data.index()).channel();
                return new ClientboundCustomPayloadPacket(id, buf);
            }
            ResourceLocation id = PacketUtilsImpl.PLAY_C2S_PACKET.get(data.index()).channel();
            return new ServerboundCustomPayloadPacket(id, buf);
        }
        return packet;
    }
}

