/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.loader;

import java.nio.file.Path;
import java.nio.file.Paths;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.ValueConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import net.flytre.flytre_lib.loader.ItemTabCreatorImpl;
import net.flytre.flytre_lib.loader.LoaderAgnosticRegistryImpl;
import net.flytre.flytre_lib.loader.LoaderPropertiesImpl;
import net.flytre.flytre_lib.loader.LootRegistryImpl;
import net.flytre.flytre_lib.loader.RenderLayerRegistryImpl;
import net.flytre.flytre_lib.loader.ScreenLoaderUtilsImpl;
import net.minecraftforge.fml.loading.FMLPaths;

public final class LoaderPropertyInitializer {
    private LoaderPropertyInitializer() {
    }

    public static void init(String[] args) {
        OptionParser parser = new OptionParser();
        parser.allowsUnrecognizedOptions();
        ArgumentAcceptingOptionSpec gameDir = parser.accepts("gameDir", "Alternative game directory").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[]{PathProperties.DIRECTORY_EXISTING})).defaultsTo((Object)Path.of(".", new String[0]), (Object[])new Path[0]);
        parser.allowsUnrecognizedOptions();
        OptionSet optionSet = parser.parse(args);
        Path configDir = Paths.get(((Path)optionSet.valueOf((OptionSpec)gameDir)).toString(), FMLPaths.CONFIGDIR.relative().toString());
        LoaderPropertiesImpl.init(configDir);
        LoaderAgnosticRegistryImpl.init();
        ScreenLoaderUtilsImpl.init();
        ItemTabCreatorImpl.init();
        RenderLayerRegistryImpl.init();
        LootRegistryImpl.init();
    }
}

