/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.loader;

import java.nio.file.Path;
import net.flytre.flytre_lib.loader.LoaderProperties;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.commons.lang3.StringUtils;

final class LoaderPropertiesImpl
implements LoaderProperties.Delegate {
    private final Path configDir;

    private LoaderPropertiesImpl(Path configDir) {
        this.configDir = configDir;
    }

    public static void init(Path configDir) {
        LoaderProperties.setDelegate(new LoaderPropertiesImpl(configDir));
    }

    @Override
    public Path getModConfigDirectory() {
        return this.configDir;
    }

    @Override
    public String getModName(String id) {
        return ModList.get().getModContainerById(id).map(modContainer -> modContainer.getModInfo().getDisplayName()).orElse(StringUtils.capitalize((String)id));
    }

    @Override
    public boolean isDevEnvironment() {
        return !FMLEnvironment.production;
    }

    @Override
    public LoaderProperties.Loader getLoader() {
        return LoaderProperties.Loader.FORGE;
    }
}

