/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.loader;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.flytre.flytre_lib.loader.CachedSupplier;
import net.flytre.flytre_lib.loader.ExtendedScreenHandlerFactory;
import net.flytre.flytre_lib.loader.LoaderAgnosticRegistry;
import net.flytre.flytre_lib.loader.SimpleScreenHandlerFactory;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

final class LoaderAgnosticRegistryImpl
implements LoaderAgnosticRegistry.Delegate {
    private static final Map<String, DeferredRegister<Block>> BLOCK_REGISTRIES = new HashMap<String, DeferredRegister<Block>>();
    private static final Map<String, DeferredRegister<Item>> ITEM_REGISTRIES = new HashMap<String, DeferredRegister<Item>>();
    private static final Map<String, DeferredRegister<EntityType<?>>> ENTITY_REGISTRIES = new HashMap();
    private static final Map<String, DeferredRegister<MenuType<?>>> SCREEN_HANDLER_REGISTRIES = new HashMap();
    private static final Map<String, DeferredRegister<BlockEntityType<?>>> BLOCK_ENTITY_REGISTRIES = new HashMap();
    private static final Map<String, DeferredRegister<RecipeSerializer<?>>> RECIPE_SERIALIZER_REGISTRIES = new HashMap();
    private static final Map<String, DeferredRegister<RecipeType<?>>> RECIPE_TYPE_REGISTRIES = new HashMap();
    private static final Map<String, DeferredRegister<ParticleType<?>>> PARTICLE_TYPE_REGISTRIES = new HashMap();
    private static final Map<String, DeferredRegister<SoundEvent>> SOUND_EVENT_REGISTRIES = new HashMap<String, DeferredRegister<SoundEvent>>();
    private static final Set<String> REGISTERED_MODS = new HashSet<String>();

    private LoaderAgnosticRegistryImpl() {
    }

    public static void init() {
        LoaderAgnosticRegistry.setDelegate(new LoaderAgnosticRegistryImpl());
    }

    private static List<Map<String, ? extends DeferredRegister<?>>> getRegistries() {
        return List.of(BLOCK_REGISTRIES, ITEM_REGISTRIES, ENTITY_REGISTRIES, SCREEN_HANDLER_REGISTRIES, BLOCK_ENTITY_REGISTRIES, RECIPE_TYPE_REGISTRIES, RECIPE_SERIALIZER_REGISTRIES, PARTICLE_TYPE_REGISTRIES, SOUND_EVENT_REGISTRIES);
    }

    public static void register(String mod) {
        if (REGISTERED_MODS.contains(mod)) {
            return;
        }
        REGISTERED_MODS.add(mod);
        LoaderAgnosticRegistryImpl.getRegistries().forEach(map -> Optional.ofNullable((DeferredRegister)map.get(mod)).ifPresent(reg -> reg.register(FMLJavaModLoadingContext.get().getModEventBus())));
    }

    @Override
    public <T extends Block> Supplier<T> registerBlock(Supplier<T> block, String mod, String id) {
        block = CachedSupplier.of(block);
        BLOCK_REGISTRIES.putIfAbsent(mod, (DeferredRegister<Block>)DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)mod));
        BLOCK_REGISTRIES.get(mod).register(id, block);
        return block;
    }

    @Override
    public <T extends Item> Supplier<T> registerItem(Supplier<T> item, String mod, String id) {
        item = CachedSupplier.of(item);
        ITEM_REGISTRIES.putIfAbsent(mod, (DeferredRegister<Item>)DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)mod));
        ITEM_REGISTRIES.get(mod).register(id, item);
        return item;
    }

    @Override
    public <E extends Entity, T extends EntityType<E>> Supplier<T> registerEntity(Supplier<T> entity, String mod, String id) {
        entity = CachedSupplier.of(entity);
        ENTITY_REGISTRIES.putIfAbsent(mod, DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)mod));
        ENTITY_REGISTRIES.get(mod).register(id, entity);
        return entity;
    }

    @Override
    public <T extends AbstractContainerMenu> Supplier<MenuType<T>> registerSimpleScreen(SimpleScreenHandlerFactory<T> factory, String mod, String id) {
        SCREEN_HANDLER_REGISTRIES.putIfAbsent(mod, DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)mod));
        CachedSupplier<MenuType<T>> type = CachedSupplier.of(() -> IForgeMenuType.create((syncId, playerInv, packet) -> factory.create(syncId, playerInv)));
        SCREEN_HANDLER_REGISTRIES.get(mod).register(id, type);
        return type;
    }

    @Override
    public <T extends AbstractContainerMenu> Supplier<MenuType<T>> registerExtendedScreen(ExtendedScreenHandlerFactory<T> factory, String mod, String id) {
        SCREEN_HANDLER_REGISTRIES.putIfAbsent(mod, DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)mod));
        CachedSupplier<MenuType<T>> type = CachedSupplier.of(() -> IForgeMenuType.create(factory::create));
        SCREEN_HANDLER_REGISTRIES.get(mod).register(id, type);
        return type;
    }

    @Override
    public <K extends BlockEntity> Supplier<BlockEntityType<K>> registerBlockEntityType(Supplier<BlockEntityType<K>> type, String mod, String id) {
        type = CachedSupplier.of(type);
        BLOCK_ENTITY_REGISTRIES.putIfAbsent(mod, DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITIES, (String)mod));
        BLOCK_ENTITY_REGISTRIES.get(mod).register(id, type);
        return type;
    }

    @Override
    public <T extends RecipeSerializer<?>> Supplier<T> registerRecipe(Supplier<T> recipe, String mod, String id) {
        recipe = CachedSupplier.of(recipe);
        RECIPE_SERIALIZER_REGISTRIES.putIfAbsent(mod, DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)mod));
        RECIPE_SERIALIZER_REGISTRIES.get(mod).register(id, recipe);
        return recipe;
    }

    @Override
    public <T extends RecipeType<?>> Supplier<T> registerRecipeType(Supplier<T> recipeType, String mod, String id) {
        recipeType = CachedSupplier.of(recipeType);
        RECIPE_TYPE_REGISTRIES.putIfAbsent(mod, DeferredRegister.create((ResourceKey)Registry.f_122914_, (String)mod));
        RECIPE_TYPE_REGISTRIES.get(mod).register(id, recipeType);
        return recipeType;
    }

    @Override
    public <T extends ParticleType<?>> Supplier<T> registerParticleType(Supplier<T> particleType, String mod, String id) {
        particleType = CachedSupplier.of(particleType);
        PARTICLE_TYPE_REGISTRIES.putIfAbsent(mod, DeferredRegister.create((ResourceKey)Registry.f_122906_, (String)mod));
        PARTICLE_TYPE_REGISTRIES.get(mod).register(id, particleType);
        return particleType;
    }

    @Override
    public <T extends SoundEvent> Supplier<T> registerSoundEvent(Supplier<T> soundEvent, String mod, String id) {
        soundEvent = CachedSupplier.of(soundEvent);
        SOUND_EVENT_REGISTRIES.putIfAbsent(mod, (DeferredRegister<SoundEvent>)DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)mod));
        SOUND_EVENT_REGISTRIES.get(mod).register(id, soundEvent);
        return soundEvent;
    }
}

