/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.loader;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.flytre.flytre_lib.loader.EntityAttributeSetter;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;

final class EntityAttributeSetterImpl
implements EntityAttributeSetter.Delegate {
    private static final List<EntityAttributeEntries> ENTITY_ATTRIBUTES = new ArrayList<EntityAttributeEntries>();

    private EntityAttributeSetterImpl() {
    }

    public static List<EntityAttributeEntries> getEntityAttributes() {
        return ImmutableList.copyOf(ENTITY_ATTRIBUTES);
    }

    public static void init() {
        EntityAttributeSetter.setDelegate(new EntityAttributeSetterImpl());
    }

    @Override
    public void set(EntityType<? extends LivingEntity> entityType, Supplier<AttributeSupplier.Builder> attributes) {
        ENTITY_ATTRIBUTES.add(new EntityAttributeEntries(entityType, attributes));
    }

    record EntityAttributeEntries(EntityType<? extends LivingEntity> entityType, Supplier<AttributeSupplier.Builder> attributes) {
    }
}

