/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.loader;

import java.util.function.Supplier;
import net.flytre.flytre_lib.loader.LoaderAgnosticClientRegistryImpl;
import net.flytre.flytre_lib.loader.RenderLayerRegistryImpl;
import net.flytre.flytre_lib.loader.ScreenFactory;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="flytre_lib", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ClientEvents {
    private ClientEvents() {
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers registerRenderersEvent) {
        for (LoaderAgnosticClientRegistryImpl.EntityRendererEntry<?> entityRendererEntry : LoaderAgnosticClientRegistryImpl.getEntityRenderers()) {
            ClientEvents.unpackAndRegister(registerRenderersEvent, entityRendererEntry);
        }
        for (LoaderAgnosticClientRegistryImpl.BlockEntityRendererEntry blockEntityRendererEntry : LoaderAgnosticClientRegistryImpl.getBlockEntityRenderers()) {
            ClientEvents.unpackAndRegister(registerRenderersEvent, blockEntityRendererEntry);
        }
    }

    private static <T extends Entity> void unpackAndRegister(EntityRenderersEvent.RegisterRenderers registerRenderersEvent, LoaderAgnosticClientRegistryImpl.EntityRendererEntry<T> entry) {
        EntityType<T> type = entry.type().get();
        EntityRendererProvider<T> factory = entry.factory();
        registerRenderersEvent.registerEntityRenderer(type, factory);
    }

    public static <E extends BlockEntity> void unpackAndRegister(EntityRenderersEvent.RegisterRenderers registerRenderersEvent, LoaderAgnosticClientRegistryImpl.BlockEntityRendererEntry<E> entry) {
        BlockEntityType<E> type = entry.blockEntityType().get();
        BlockEntityRendererProvider<E> factory = entry.blockEntityRendererFactory();
        registerRenderersEvent.registerBlockEntityRenderer(type, factory);
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            RenderLayerRegistryImpl.getBlockLayers().forEach(pair -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)((Supplier)pair.m_14419_()).get()), (RenderType)((RenderType)pair.m_14418_())));
            RenderLayerRegistryImpl.getFluidLayers().forEach(pair -> ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)((Supplier)pair.m_14419_()).get()), (RenderType)((RenderType)pair.m_14418_())));
            LoaderAgnosticClientRegistryImpl.getScreenRegistryEntries().forEach(ClientEvents::unpack);
        });
    }

    private static <H extends AbstractContainerMenu, S extends Screen> void unpack(LoaderAgnosticClientRegistryImpl.ScreenRegistryEntry<H, S> entry) {
        ScreenFactory<H, S> factory = entry.screenFactory();
        MenuType<H> type = entry.type().get();
        MenuScreens.m_96206_(type, factory::create);
    }
}

