/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.impl.storage.upgrade.network;

import java.util.List;
import net.flytre.flytre_lib.api.base.util.PacketUtils;
import net.flytre.flytre_lib.impl.storage.upgrade.network.ClientHelper;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class UpgradeInventoryS2CPacket
implements Packet<ClientGamePacketListener> {
    private final int syncId;
    private final NonNullList<ItemStack> stacks;

    public UpgradeInventoryS2CPacket(int syncId, NonNullList<ItemStack> stacks) {
        this.syncId = syncId;
        this.stacks = stacks;
    }

    public UpgradeInventoryS2CPacket(FriendlyByteBuf buf) {
        this.syncId = buf.readInt();
        List<ItemStack> temp = PacketUtils.listFromPacket(buf, FriendlyByteBuf::m_130267_);
        this.stacks = NonNullList.m_122780_((int)temp.size(), (Object)ItemStack.f_41583_);
        for (int j = 0; j < this.stacks.size(); ++j) {
            this.stacks.set(j, (Object)temp.get(j));
        }
    }

    public void m_5779_(FriendlyByteBuf buf) {
        buf.writeInt(this.syncId);
        PacketUtils.toPacket(buf, this.stacks, (stack, p) -> p.m_130055_(stack));
    }

    public int getSyncId() {
        return this.syncId;
    }

    public NonNullList<ItemStack> getStacks() {
        return this.stacks;
    }

    public void apply(ClientGamePacketListener listener) {
        ClientHelper.apply(this, listener);
    }
}

