/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.impl.storage.upgrade.network;

import java.util.Map;
import net.flytre.flytre_lib.api.storage.upgrade.UpgradeHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class UpgradeClickSlotC2SPacket
implements Packet<ServerGamePacketListener> {
    private final int syncId;
    private final int slot;
    private final int button;
    private final ClickType actionType;
    private final Map<Integer, ItemStack> modifiedStacks;
    private final ItemStack cursorStack;

    public UpgradeClickSlotC2SPacket(int syncId, int slot, int button, ClickType actionType, Map<Integer, ItemStack> modifiedStacks, ItemStack cursorStack) {
        this.syncId = syncId;
        this.slot = slot;
        this.button = button;
        this.actionType = actionType;
        this.modifiedStacks = modifiedStacks;
        this.cursorStack = cursorStack;
    }

    public UpgradeClickSlotC2SPacket(FriendlyByteBuf buf) {
        this.syncId = buf.readByte();
        this.slot = buf.readShort();
        this.button = buf.readByte();
        this.actionType = (ClickType)buf.m_130066_(ClickType.class);
        this.modifiedStacks = buf.m_178368_(packetByteBuf -> packetByteBuf.readShort(), FriendlyByteBuf::m_130267_);
        this.cursorStack = buf.m_130267_();
    }

    public void m_5779_(FriendlyByteBuf buf) {
        buf.writeByte(this.syncId);
        buf.writeShort(this.slot);
        buf.writeByte(this.button);
        buf.m_130068_((Enum)this.actionType);
        buf.m_178355_(this.modifiedStacks, FriendlyByteBuf::writeShort, FriendlyByteBuf::m_130055_);
        buf.m_130055_(this.cursorStack);
    }

    public void apply(ServerGamePacketListener listener) {
        ServerPlayer player = ((ServerGamePacketListenerImpl)listener).m_142253_();
        MinecraftServer server = player.m_20194_();
        assert (server != null);
        server.execute(() -> this.run(player));
    }

    public void run(ServerPlayer player) {
        player.m_9243_();
        if (player.f_36096_.f_38840_ == this.syncId && player.f_36096_ instanceof UpgradeHandler) {
            if (player.m_5833_()) {
                player.f_36096_.m_150429_();
            } else {
                player.f_36096_.m_150443_();
                ((UpgradeHandler)player.f_36096_).onUpgradeSlotClick(this.slot, this.button, this.actionType, (Player)player);
                for (Map.Entry<Integer, ItemStack> entry : this.modifiedStacks.entrySet()) {
                    ((UpgradeHandler)player.f_36096_).setPreviousTrackedUpgradeSlot(entry.getKey(), entry.getValue());
                }
                player.f_36096_.m_150422_(this.cursorStack);
                player.f_36096_.m_150444_();
                player.f_36096_.m_38946_();
            }
        }
    }
}

