/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.impl.config.client;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.flytre.flytre_lib.api.config.annotation.Button;
import net.flytre.flytre_lib.api.gui.button.TranslucentButton;
import net.flytre.flytre_lib.api.gui.button.TranslucentCyclingButtonWidget;
import net.flytre.flytre_lib.api.gui.text_field.TranslucentTextField;
import net.flytre.flytre_lib.impl.config.client.ConfigError;
import net.flytre.flytre_lib.impl.config.client.ConfigStyleList;
import net.flytre.flytre_lib.impl.config.client.GenericConfigScreen;
import net.flytre.flytre_lib.impl.config.client.GuiMaker;
import net.flytre.flytre_lib.impl.config.client.ListEditorWidget;
import net.flytre.flytre_lib.mixin.config.SliderWidgetAccessor;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
class ListEditorScreen<T extends AbstractWidget>
extends GenericConfigScreen {
    private final Button buttonAnnotation;
    private final Consumer<List<Object>> saver;
    private final List<T> initial;
    private final Supplier<T> adder;
    private ListEditorWidget<T> list;

    public ListEditorScreen(@Nullable Screen parent, @Nullable net.minecraft.client.gui.components.Button reopen, Consumer<List<Object>> saver, List<T> initial, Supplier<T> adder, @Nullable Button buttonAnnotation) {
        super(parent, reopen);
        this.saver = saver;
        this.initial = initial;
        this.adder = adder;
        this.buttonAnnotation = buttonAnnotation;
    }

    @Override
    public void onClose() {
        super.onClose();
        this.saver.accept(this.list.m_6702_().stream().map(ListEditorWidget.ValueEntry::getClickable).map(this::toValue).filter(i -> !(i instanceof String) || ((String)i).length() != 0).collect(Collectors.toList()));
    }

    @Override
    public ConfigStyleList<?> getList() {
        return this.list;
    }

    private Object toValue(AbstractWidget clickable) {
        if (clickable instanceof TranslucentTextField) {
            return ((TranslucentTextField)clickable).getText();
        }
        if (clickable instanceof AbstractSliderButton) {
            return ((SliderWidgetAccessor)clickable).getValue();
        }
        if (clickable instanceof TranslucentCyclingButtonWidget) {
            return ((TranslucentCyclingButtonWidget)clickable).getValue();
        }
        throw new ConfigError("Unknown type: " + clickable.m_142684_());
    }

    protected void m_7856_() {
        this.list = new ListEditorWidget(this.f_96541_, this.f_96543_, this.f_96544_, 60, this.f_96544_ - 60, 30);
        this.initial.forEach(i -> this.list.addEntry(i));
        if (this.list.m_6702_().isEmpty()) {
            this.list.addEntry((AbstractWidget)this.adder.get());
        }
        this.m_142416_((GuiEventListener)this.list);
        Runnable customButtonFunc = GuiMaker.getRunnable(this.buttonAnnotation);
        int offset = this.f_96543_ / 8 + (customButtonFunc == null ? 0 : this.f_96543_ / 5);
        TranslucentButton entryAdder = new TranslucentButton(this.f_96543_ / 2 - this.f_96543_ / 10 - offset, this.f_96544_ - 30, this.f_96543_ / 5, 20, (Component)new TranslatableComponent("flytre_lib.gui.add"), button -> this.list.addEntry((AbstractWidget)this.adder.get()));
        this.m_142416_((GuiEventListener)entryAdder);
        TranslucentButton done = new TranslucentButton(this.f_96543_ / 2 - this.f_96543_ / 10 + offset, this.f_96544_ - 30, this.f_96543_ / 5, 20, (Component)new TranslatableComponent("flytre_lib.gui.done"), button -> this.onClose());
        this.m_142416_((GuiEventListener)done);
        if (customButtonFunc != null) {
            @Nullable TranslucentButton customButton = new TranslucentButton(this.f_96543_ / 2 - this.f_96543_ / 10, this.f_96544_ - 30, this.f_96543_ / 5, 20, (Component)new TranslatableComponent(this.buttonAnnotation.translationKey()), x -> {
                this.onClose();
                customButtonFunc.run();
                this.reopenAction();
            });
            this.m_142416_((GuiEventListener)customButton);
        }
        super.m_7856_();
    }
}

